/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import gov.wa.wsdot.ferries.schedule.ArrayOfSchedTerminalCombo;
import gov.wa.wsdot.ferries.schedule.ArrayOfSchedTime;
import gov.wa.wsdot.ferries.schedule.SchedResponse;
import gov.wa.wsdot.ferries.schedule.SchedTerminalCombo;
import gov.wa.wsdot.ferries.schedule.SchedTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.impl.WSFScheduleService;
import org.onebusaway.gtfs_transformer.impl.WSFTripResolutionService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSFBlockResolutionStrategy
implements GtfsTransformStrategy {
    private static final Logger _log = LoggerFactory.getLogger(WSFBlockResolutionStrategy.class);
    @CsvField(ignore=true)
    private GtfsMutableRelationalDao _dao;
    @CsvField(ignore=true)
    private String _agencyId;
    @CsvField(ignore=true)
    private TimeZone _agencyTimeZone;
    @CsvField(ignore=true)
    private WSFTripResolutionService _tripResolutionService;
    @CsvField(ignore=true)
    private WSFScheduleService _scheduleService;
    private String apiAccessCode = "";

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        this._dao = dao;
        Agency agency = (Agency)dao.getAllAgencies().iterator().next();
        this._agencyId = agency.getId();
        this._agencyTimeZone = TimeZone.getTimeZone(agency.getTimezone());
        this._tripResolutionService = new WSFTripResolutionService((GtfsRelationalDao)this._dao, this._agencyId, this._agencyTimeZone);
        try {
            this._scheduleService = new WSFScheduleService(this.apiAccessCode);
            this.setAllBlockIds();
        }
        catch (Exception e) {
            _log.error("Error initializing WSFBlockResolutionStrategy: " + e);
            return;
        }
    }

    public void setApiAccessCode(String apiAccessCode) {
        this.apiAccessCode = apiAccessCode;
    }

    private void setAllBlockIds() throws InterruptedException {
        Collection trips = this._dao.getAllTrips();
        HashMap<BlockTask, BlockTask> tripsMap = new HashMap<BlockTask, BlockTask>();
        for (Trip t : trips) {
            BlockTask task = new BlockTask(t);
            if (task.isInPast()) continue;
            if (!tripsMap.containsKey(task)) {
                tripsMap.put(task, task);
            }
            task = (BlockTask)tripsMap.get(task);
            task.addTrip(t);
        }
        Set jobs = tripsMap.keySet();
        int nCores = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(nCores * 2);
        executor.invokeAll(jobs);
    }

    private void setBlockIdsFromSchedResponse(SchedResponse resp) {
        List combos = ((ArrayOfSchedTerminalCombo)resp.getTerminalCombos().getValue()).getSchedTerminalCombo();
        for (SchedTerminalCombo stc : combos) {
            String depart = stc.getDepartingTerminalID().toString();
            String arrive = stc.getArrivingTerminalID().toString();
            for (SchedTime sched : this.schedTime(stc)) {
                long time = this.ts(sched.getDepartingTime());
                Trip trip = this._tripResolutionService.resolve(depart, time, arrive);
                if (trip != null) {
                    trip.setBlockId(sched.getVesselID().toString());
                    continue;
                }
                _log.warn("Skipping schedTime due to no matching trip {}", (Object)sched.toString());
            }
        }
    }

    private String id(StopLocation st) {
        return st.getId().getId();
    }

    private Date date(ServiceCalendar cal) {
        return cal.getStartDate().getAsDate(this._agencyTimeZone);
    }

    private List<SchedTime> schedTime(SchedTerminalCombo st) {
        return ((ArrayOfSchedTime)st.getTimes().getValue()).getSchedTime();
    }

    private long ts(XMLGregorianCalendar xgc) {
        GregorianCalendar gc = xgc.toGregorianCalendar(this._agencyTimeZone, null, null);
        return gc.getTimeInMillis() / 1000L;
    }

    class BlockTask
    implements Callable<Boolean> {
        Route route;
        ServiceCalendar cal;
        List<Trip> trips;

        BlockTask(Trip t) {
            this.route = t.getRoute();
            this.cal = WSFBlockResolutionStrategy.this._dao.getCalendarForServiceId(t.getServiceId());
        }

        @Override
        public Boolean call() {
            List stops = WSFBlockResolutionStrategy.this._dao.getStopTimesForTrip(this.trips.get(0));
            StopLocation orig = ((StopTime)stops.get(0)).getStop();
            StopLocation dest = ((StopTime)stops.get(1)).getStop();
            _log.info("Submitting WSF block task for {} ({}, {})", new Object[]{this.cal, orig, dest});
            SchedResponse resp = WSFBlockResolutionStrategy.this._scheduleService.getSchedule(WSFBlockResolutionStrategy.this.date(this.cal), WSFBlockResolutionStrategy.this.id(orig), WSFBlockResolutionStrategy.this.id(dest));
            WSFBlockResolutionStrategy.this.setBlockIdsFromSchedResponse(resp);
            return true;
        }

        void addTrip(Trip t) {
            if (this.trips == null) {
                this.trips = new ArrayList<Trip>();
            }
            this.trips.add(t);
        }

        boolean isInPast() {
            Calendar today = Calendar.getInstance();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
            return WSFBlockResolutionStrategy.this.date(this.cal).before(today.getTime());
        }

        public int hashCode() {
            return this.route.hashCode() * 17 + this.cal.getServiceId().hashCode() * 31;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BlockTask)) {
                return false;
            }
            BlockTask k = (BlockTask)o;
            if (!this.route.equals((Object)k.route)) {
                return false;
            }
            return this.cal.equals((Object)k.cal);
        }
    }
}

