/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountAndTest
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(CountAndTest.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        int countSt = 0;
        int countCd = 0;
        int countNoSt = 0;
        int countNoCd = 0;
        int curSerTrips = 0;
        int tomSerTrips = 0;
        int countNoHs = 0;
        String agency = ((Agency)dao.getAllAgencies().iterator().next()).getId();
        String name = ((Agency)dao.getAllAgencies().iterator().next()).getName();
        AgencyAndId serviceAgencyAndId = new AgencyAndId();
        for (Trip trip : dao.getAllTrips()) {
            ServiceCalendar servCal;
            ServiceCalendar servCal2;
            if (dao.getStopTimesForTrip(trip).size() == 0) {
                ++countNoSt;
            } else {
                ++countSt;
            }
            serviceAgencyAndId = trip.getServiceId();
            if (dao.getCalendarDatesForServiceId(serviceAgencyAndId).size() == 0) {
                ++countNoCd;
            } else {
                ++countCd;
            }
            Date today = this.removeTime(new Date());
            boolean hasCalDateException = false;
            if (!dao.getCalendarDatesForServiceId(trip.getServiceId()).isEmpty()) {
                for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                    Date date = this.constructDate(calDate.getDate());
                    if (!date.equals(today)) continue;
                    hasCalDateException = true;
                    if (calDate.getExceptionType() == 1) {
                        ++curSerTrips;
                        break;
                    }
                    if (calDate.getExceptionType() != 2) continue;
                    break;
                }
            }
            if (!hasCalDateException && (servCal2 = dao.getCalendarForServiceId(trip.getServiceId())) != null) {
                Date start = this.removeTime(servCal2.getStartDate().getAsDate());
                Date end = this.removeTime(servCal2.getEndDate().getAsDate());
                if (today.equals(start) || today.equals(end) || today.after(start) && today.before(end)) {
                    ++curSerTrips;
                }
            }
            Date tomorrow = this.removeTime(this.addDays(new Date(), 1));
            hasCalDateException = false;
            if (!dao.getCalendarDatesForServiceId(trip.getServiceId()).isEmpty()) {
                for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                    Date date = this.removeTime(calDate.getDate().getAsDate());
                    if (!date.equals(tomorrow)) continue;
                    hasCalDateException = true;
                    if (calDate.getExceptionType() == 1) {
                        ++tomSerTrips;
                        break;
                    }
                    if (calDate.getExceptionType() != 2) continue;
                    break;
                }
            }
            if (!hasCalDateException && (servCal = dao.getCalendarForServiceId(trip.getServiceId())) != null) {
                Date start = this.removeTime(servCal.getStartDate().getAsDate());
                Date end = this.removeTime(servCal.getEndDate().getAsDate());
                if (tomorrow.equals(start) || tomorrow.equals(end) || tomorrow.after(start) && tomorrow.before(end)) {
                    ++tomSerTrips;
                }
            }
            if (trip.getTripHeadsign() != null) continue;
            ++countNoHs;
            this._log.error("Trip {} has no headsign", (Object)trip.getId());
        }
        this._log.info("Agency: {}, {}. Routes: {}, Trips: {}, Current Service: {}, Stops: {}, Stop times {}, Trips w/ st: {}, Trips w/out st: {}, Total trips w/out headsign: {}", new Object[]{agency, name, dao.getAllRoutes().size(), dao.getAllTrips().size(), curSerTrips, dao.getAllStops().size(), dao.getAllStopTimes().size(), countSt, countNoSt, countNoHs});
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        String feed = CloudContextService.getLikelyFeedName(dao);
        HashSet<String> ids = new HashSet<String>();
        for (Stop stop : dao.getAllStops()) {
            if (ids.contains(stop.getId().getId())) {
                this._log.error("Duplicate stop ids! Agency {} stop id {}", (Object)agency, (Object)stop.getId().getId());
                es.publishMultiDimensionalMetric(CloudContextService.getNamespace(), "DuplicateStopIds", new String[]{"feed", "stopId"}, new String[]{feed, stop.getId().toString()}, 1.0);
                throw new IllegalStateException("There are duplicate stop ids!");
            }
            ids.add(stop.getId().getId());
        }
        es.publishMetric(CloudContextService.getNamespace(), "TripsInServiceToday", "feed", feed, (double)curSerTrips);
        es.publishMetric(CloudContextService.getNamespace(), "TripsInServiceTomorrow", "feed", feed, (double)tomSerTrips);
        if (curSerTrips + tomSerTrips < 1) {
            throw new IllegalStateException("There is no current service!!");
        }
        if (countNoHs > 0) {
            this._log.error("There are trips with no headsign");
        }
        es.publishMetric(CloudContextService.getNamespace(), "TripsWithoutHeadsigns", "feed", feed, (double)countNoHs);
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    private Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }

    private Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }
}

