/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.deferred;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.SingleFieldMapping;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;
import org.onebusaway.gtfs.serialization.NoDefaultAgencyIdException;
import org.onebusaway.gtfs.serialization.mappings.ConverterFactory;
import org.onebusaway.gtfs_transformer.deferred.EntitySchemaCache;

public class DeferredValueSupport {
    private final GtfsReader _reader;
    private final EntitySchemaCache _schemaCache;

    public DeferredValueSupport(GtfsReader reader, EntitySchemaCache schemaCache) {
        this._reader = reader;
        this._schemaCache = schemaCache;
    }

    public GtfsReader getReader() {
        return this._reader;
    }

    public AgencyAndId resolveAgencyAndId(BeanWrapper bean, String propertyName, String newId) {
        GtfsReaderContext context = this._reader.getGtfsReaderContext();
        String agencyId = null;
        try {
            agencyId = context.getDefaultAgencyId();
        }
        catch (NoDefaultAgencyIdException ndaie) {
            agencyId = null;
        }
        AgencyAndId existingId = (AgencyAndId)bean.getPropertyValue(propertyName);
        if (existingId != null) {
            agencyId = existingId.getAgencyId();
        }
        return new AgencyAndId(agencyId, newId);
    }

    public Converter resolveConverter(Class<?> targetEntityType, String targetPropertyName, Class<?> targetValueType) {
        SingleFieldMapping mapping = this._schemaCache.getFieldMappingForCsvFieldName(targetEntityType, targetPropertyName);
        if (mapping == null) {
            mapping = this._schemaCache.getFieldMappingForObjectFieldName(targetEntityType, targetPropertyName);
        }
        if (mapping != null) {
            if (mapping instanceof ConverterFactory) {
                ConverterFactory factory = (ConverterFactory)mapping;
                return factory.create(this._reader.getContext());
            }
            if (mapping instanceof Converter) {
                return (Converter)mapping;
            }
        }
        return ConvertUtils.lookup(targetValueType);
    }
}

