/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.geospatial.services;

import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.UTMProjection;

public class UTMLibrary {
    private static final String LAT_ZONES = "CDEFGHJKLMNPQRSTUVWX";

    public static UTMProjection getProjectionForPoint(CoordinatePoint point) {
        return new UTMProjection(UTMLibrary.getUTMZoneForLongitude(point.getLon()));
    }

    public static UTMProjection getProjectionForPoint(double lat, double lon) {
        return new UTMProjection(UTMLibrary.getUTMZoneForLongitude(lon));
    }

    public static String getUTMZone(CoordinatePoint point) {
        return UTMLibrary.getUTMZone(point.getLat(), point.getLon());
    }

    public static String getUTMZone(double lat, double lon) {
        return Integer.toString(UTMLibrary.getUTMZoneForLongitude(lon)) + UTMLibrary.getUTMZoneForLatitude(lat);
    }

    public static int getUTMZoneForLongitude(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            throw new IllegalArgumentException("Coordinates not within UTM zone limits");
        }
        int lonZone = (int)((lon + 180.0) / 6.0);
        if (lonZone == 60) {
            --lonZone;
        }
        return lonZone + 1;
    }

    public static char getUTMZoneForLatitude(double lat) {
        int latZone = UTMLibrary.getUTMIndexForLatitude(lat);
        return LAT_ZONES.charAt(latZone);
    }

    private static int getUTMIndexForLatitude(double lat) {
        if (lat < -80.0 || lat > 84.0) {
            throw new IllegalArgumentException("Coordinates not within UTM zone limits");
        }
        int latZone = (int)((lat + 80.0) / 8.0);
        if (latZone == 20) {
            --latZone;
        }
        return latZone;
    }
}

