/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.geospatial.services;

import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.model.XYPoint;
import org.onebusaway.geospatial.services.GeometryLibrary;

public class SphericalGeometryLibrary {
    public static final double RADIUS_OF_EARTH_IN_KM = 6371.01;
    public static final double COS_MAX_LAT = Math.cos(0.8028514559173915);
    public static final double METERS_PER_DEGREE_AT_EQUATOR = 111319.9;

    public static double distanceFaster(double lat1, double lon1, double lat2, double lon2) {
        double lonDelta = lon2 - lon1;
        double latDelta = lat2 - lat1;
        return Math.sqrt(lonDelta * lonDelta + latDelta * latDelta) * 111319.9 * COS_MAX_LAT;
    }

    public static final double distance(double lat1, double lon1, double lat2, double lon2) {
        return SphericalGeometryLibrary.distance(lat1, lon1, lat2, lon2, 6371010.0);
    }

    public static final double distance(CoordinatePoint a, CoordinatePoint b) {
        return SphericalGeometryLibrary.distance(a.getLat(), a.getLon(), b.getLat(), b.getLon());
    }

    public static final double distance(double lat1, double lon1, double lat2, double lon2, double radius) {
        lat1 = Math.toRadians(lat1);
        lon1 = Math.toRadians(lon1);
        lat2 = Math.toRadians(lat2);
        lon2 = Math.toRadians(lon2);
        double deltaLon = lon2 - lon1;
        double y = Math.sqrt(SphericalGeometryLibrary.p2(Math.cos(lat2) * Math.sin(deltaLon)) + SphericalGeometryLibrary.p2(Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon)));
        double x = Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        return radius * Math.atan2(y, x);
    }

    public static final CoordinateBounds bounds(CoordinatePoint point, double distance) {
        return SphericalGeometryLibrary.bounds(point.getLat(), point.getLon(), distance);
    }

    public static CoordinateBounds bounds(CoordinateBounds b, double distance) {
        CoordinateBounds b2 = SphericalGeometryLibrary.bounds(b.getMinLat(), b.getMinLon(), distance);
        CoordinateBounds b3 = SphericalGeometryLibrary.bounds(b.getMaxLat(), b.getMaxLon(), distance);
        b2.addBounds(b3);
        return b2;
    }

    public static final CoordinateBounds bounds(double lat, double lon, double distance) {
        return SphericalGeometryLibrary.bounds(lat, lon, distance, distance);
    }

    public static final CoordinateBounds bounds(double lat, double lon, double latDistance, double lonDistance) {
        double radiusOfEarth = 6371010.0;
        double latRadians = Math.toRadians(lat);
        double lonRadians = Math.toRadians(lon);
        double latRadius = radiusOfEarth;
        double lonRadius = Math.cos(latRadians) * radiusOfEarth;
        double latOffset = latDistance / latRadius;
        double lonOffset = lonDistance / lonRadius;
        double latFrom = Math.toDegrees(latRadians - latOffset);
        double latTo = Math.toDegrees(latRadians + latOffset);
        double lonFrom = Math.toDegrees(lonRadians - lonOffset);
        double lonTo = Math.toDegrees(lonRadians + lonOffset);
        return new CoordinateBounds(latFrom, lonFrom, latTo, lonTo);
    }

    public static final CoordinateBounds boundsFromLatLonOffset(double lat, double lon, double latOffset, double lonOffset) {
        double latFrom = lat - latOffset;
        double latTo = lat + latOffset;
        double lonFrom = lon - lonOffset;
        double lonTo = lon + lonOffset;
        return new CoordinateBounds(latFrom, lonFrom, latTo, lonTo);
    }

    public static final CoordinateBounds boundsFromLatLonSpan(double lat, double lon, double latSpan, double lonSpan) {
        return SphericalGeometryLibrary.boundsFromLatLonOffset(lat, lon, latSpan / 2.0, lonSpan / 2.0);
    }

    public static CoordinatePoint getCenterOfBounds(CoordinateBounds b) {
        return new CoordinatePoint((b.getMinLat() + b.getMaxLat()) / 2.0, (b.getMinLon() + b.getMaxLon()) / 2.0);
    }

    public static double getOrientation(double latFrom, double lonFrom, double latTo, double lonTo) {
        double d = SphericalGeometryLibrary.distance(latFrom, lonFrom, latTo, lonTo);
        CoordinateBounds bounds = SphericalGeometryLibrary.bounds(latFrom, lonFrom, d);
        XYPoint origin = new XYPoint(lonFrom, latFrom);
        XYPoint axis = new XYPoint(bounds.getMaxLon(), latFrom);
        XYPoint target = new XYPoint(lonTo, latTo);
        double angle = GeometryLibrary.getAngle(origin, axis, target);
        if (latTo < latFrom) {
            angle = Math.PI * 2 - angle;
        }
        return Math.toDegrees(angle);
    }

    public static CoordinatePoint projectPointToSegmentAppropximate(CoordinatePoint point, CoordinatePoint segmentStart, CoordinatePoint segmentEnd) {
        XYPoint pPoint = new XYPoint(point.getLon(), point.getLat());
        XYPoint pSegmentStart = new XYPoint(segmentStart.getLon(), segmentStart.getLat());
        XYPoint pSegmentEnd = new XYPoint(segmentEnd.getLon(), segmentEnd.getLat());
        XYPoint pResult = GeometryLibrary.projectPointToSegment(pPoint, pSegmentStart, pSegmentEnd);
        return new CoordinatePoint(pResult.getY(), pResult.getX());
    }

    private static final double p2(double a) {
        return a * a;
    }
}

