/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.geospatial.services;

import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionFactory;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.model.XYPoint;
import org.onebusaway.geospatial.services.ICoordinateProjection;

public class Proj4Projection
implements ICoordinateProjection,
Serializable {
    private static final long serialVersionUID = 1L;
    private String[] _spec;
    private transient Projection _projection;

    public Proj4Projection(String ... spec) {
        this._spec = spec;
        this.populateProjection();
    }

    public String[] getSpec() {
        return this._spec;
    }

    @Override
    public XYPoint forward(CoordinatePoint point) {
        Point2D.Double from = new Point2D.Double(point.getLon(), point.getLat());
        Point2D.Double result = new Point2D.Double();
        result = this._projection.transform(from, result);
        return new XYPoint(result.x, result.y);
    }

    @Override
    public <T extends Collection<XYPoint>> T forward(Iterable<CoordinatePoint> source, T dest, int size) {
        for (CoordinatePoint p : source) {
            dest.add((XYPoint)this.forward(p));
        }
        return dest;
    }

    @Override
    public CoordinatePoint reverse(XYPoint point) {
        Point2D.Double from = new Point2D.Double(point.getX(), point.getY());
        Point2D.Double result = new Point2D.Double();
        this._projection.inverseTransform(from, result);
        return new CoordinatePoint(result.y, result.x);
    }

    @Override
    public <T extends Collection<CoordinatePoint>> T reverse(Iterable<XYPoint> source, T dest, int size) {
        for (XYPoint p : source) {
            dest.add((CoordinatePoint)this.reverse(p));
        }
        return dest;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Proj4Projection)) {
            return false;
        }
        Proj4Projection proj = (Proj4Projection)obj;
        return Arrays.equals(this._spec, proj._spec);
    }

    public int hashCode() {
        return Arrays.hashCode(this._spec);
    }

    private void populateProjection() {
        this._projection = ProjectionFactory.fromPROJ4Specification((String[])this._spec);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._spec);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._spec = (String[])in.readObject();
        this.populateProjection();
    }
}

