/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.geospatial.services;

import org.onebusaway.geospatial.model.Point;
import org.onebusaway.geospatial.model.PointVector;

public class GeometryLibrary {
    public static final boolean inRange(double r1, double r2, double v) {
        return Math.min(r1, r2) <= v && v <= Math.max(r1, r2);
    }

    public static double normalizeAngle(double radians) {
        while (radians > Math.PI) {
            radians -= Math.PI * 2;
        }
        while (radians < -Math.PI) {
            radians += Math.PI * 2;
        }
        return radians;
    }

    public static double getAngleDifference(double radiansA, double radiansB) {
        double diff = Math.abs(GeometryLibrary.normalizeAngle(radiansA) - GeometryLibrary.normalizeAngle(radiansB));
        if (diff > Math.PI) {
            diff = Math.PI * 2 - diff;
        }
        return diff;
    }

    public static double getRelativeAngleDifference(double from, double to) {
        from = GeometryLibrary.normalizeAngle(from);
        double delta = (to = GeometryLibrary.normalizeAngle(to)) - from;
        if (delta > Math.PI) {
            delta -= Math.PI * 2;
        }
        if (delta < -Math.PI) {
            delta += Math.PI * 2;
        }
        return delta;
    }

    public static <P extends Point> double distance(P a, P b) {
        return a.getDistance(b);
    }

    public static <P extends Point> double getAngle(P origin, P a, P b) {
        PointVector va = PointVector.create(origin, a);
        PointVector vb = PointVector.create(origin, b);
        return va.getAngle(vb);
    }

    public static <P extends Point> P projectPointToLine(P point, P lineStart, P lineEnd) {
        PointVector v = PointVector.create(lineStart, point);
        PointVector line = PointVector.create(lineStart, lineEnd);
        return line.getProjection(v).addToPoint(lineStart);
    }

    public static <P extends Point> P projectPointToSegment(P point, P segmentStart, P segmentEnd) {
        double b;
        PointVector v = PointVector.create(segmentStart, point);
        PointVector line = PointVector.create(segmentStart, segmentEnd);
        P p = line.getProjection(v).addToPoint(segmentStart);
        if (GeometryLibrary.isBetween(p, segmentStart, segmentEnd)) {
            return p;
        }
        double a = p.getDistance(segmentStart);
        return a <= (b = p.getDistance(segmentEnd)) ? segmentStart : segmentEnd;
    }

    public static <P extends Point> boolean isBetween(P point, P lineStart, P lineEnd) {
        if (point.equals(lineStart) || point.equals(lineEnd)) {
            return true;
        }
        P proj = GeometryLibrary.projectPointToLine(point, lineStart, lineEnd);
        double segmentLength = lineStart.getDistance(lineEnd);
        double lenA = lineStart.getDistance(proj);
        double lenB = lineEnd.getDistance(proj);
        return lenA <= segmentLength && lenB <= segmentLength;
    }
}

