/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.geospatial.model;

import java.io.Serializable;
import org.onebusaway.geospatial.model.Point;

public final class XYPoint
implements Point,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double x;
    private final double y;

    public XYPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public XYPoint(double[] ordinates) {
        this.x = ordinates[0];
        this.y = ordinates[1];
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @Override
    public int getDimensions() {
        return 2;
    }

    @Override
    public double getOrdinate(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public XYPoint translate(double[] distances) {
        return new XYPoint(this.x + distances[0], this.y + distances[1]);
    }

    @Override
    public double getDistance(Point point) {
        XYPoint p = (XYPoint)point;
        return Math.sqrt(XYPoint.p2(this.x - p.x) + XYPoint.p2(this.y - p.y));
    }

    public String toString() {
        return "Point(" + this.x + "," + this.y + ")";
    }

    private static final double p2(double x) {
        return x * x;
    }
}

