/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.geospatial.model;

import java.util.Arrays;
import org.onebusaway.geospatial.model.Point;

public class PointVector {
    private double[] _vector;

    public static <T extends Point> PointVector create(T origin, T direction) {
        double[] vector = new double[origin.getDimensions()];
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = direction.getOrdinate(i) - origin.getOrdinate(i);
        }
        return new PointVector(vector);
    }

    public PointVector(double ... vector) {
        this._vector = vector;
    }

    public int getDimensions() {
        return this._vector.length;
    }

    public double getOrdinate(int dimension) {
        return this._vector[dimension];
    }

    public double[] getOrdinates() {
        double[] ord = new double[this._vector.length];
        System.arraycopy(this._vector, 0, ord, 0, ord.length);
        return ord;
    }

    public double getX() {
        return this._vector[0];
    }

    public double getY() {
        return this._vector[1];
    }

    public double getZ() {
        return this._vector[2];
    }

    public double length() {
        double sum = 0.0;
        for (int i = 0; i < this._vector.length; ++i) {
            sum += this._vector[i] * this._vector[i];
        }
        return Math.sqrt(sum);
    }

    public double dotProduct(PointVector v) {
        double sum = 0.0;
        for (int i = 0; i < this._vector.length; ++i) {
            sum += this._vector[i] * v.getOrdinate(i);
        }
        return sum;
    }

    public PointVector getCrossProduct(PointVector v) {
        if (this.getDimensions() != 3) {
            throw new IllegalStateException("We only handle 3D case at the moment");
        }
        double[] a = this._vector;
        double[] b = v._vector;
        double x = a[1] * b[2] - a[2] * b[1];
        double y = a[2] * b[0] - a[0] * b[2];
        double z = a[0] * b[1] - a[1] * b[0];
        return new PointVector(x, y, z);
    }

    public double getCosAngle(PointVector v) {
        return this.dotProduct(v) / (this.length() * v.length());
    }

    public double getSinAngle(PointVector v) {
        PointVector xp = this.getCrossProduct(v);
        double len = xp.length();
        return len /= this.length() * v.length();
    }

    public double getAngle(PointVector v) {
        double cosTheta = this.getCosAngle(v);
        return Math.acos(cosTheta);
    }

    public double getAngle() {
        return Math.atan2(this.getY(), this.getX());
    }

    public PointVector getScaled(double factor) {
        double[] ord = this.getOrdinates();
        int i = 0;
        while (i < ord.length) {
            int n = i++;
            ord[n] = ord[n] * factor;
        }
        return new PointVector(ord);
    }

    public PointVector getUnitVector() {
        return this.getAsLength(1.0);
    }

    public PointVector getProjection(PointVector v) {
        double dp = this.dotProduct(v) / this.length();
        return this.getAsLength(dp);
    }

    public PointVector getAsLength(double length) {
        return this.getScaled(length / this.length());
    }

    public PointVector rotate(double angle) {
        return this.rotate(angle, 0, 1);
    }

    public PointVector rotate(double angle, int dimensionA, int dimensionB) {
        double[] ord = this.getOrdinates();
        ord[dimensionA] = this._vector[dimensionA] * Math.cos(angle) + this._vector[dimensionB] * Math.sin(angle);
        ord[dimensionB] = this._vector[dimensionB] * Math.cos(angle) - this._vector[dimensionA] * Math.sin(angle);
        return new PointVector(ord);
    }

    public <T extends Point> T addToPoint(T origin) {
        return (T)origin.translate(this._vector);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PointVector)) {
            return false;
        }
        PointVector v = (PointVector)obj;
        return Arrays.equals(this._vector, v._vector);
    }

    public int hashCode() {
        return Arrays.hashCode(this._vector);
    }

    public String toString() {
        return Arrays.toString(this._vector);
    }
}

