/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.geospatial.model;

import java.io.Serializable;

public class EncodedPolylineBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String points;
    private String levels;
    private int length;

    public EncodedPolylineBean() {
    }

    public EncodedPolylineBean(String points, String levels, int length) {
        this.points = points;
        this.levels = levels;
        this.length = length;
    }

    public String getPoints() {
        return this.points;
    }

    public void setPoints(String points) {
        this.points = points;
    }

    public String getLevels() {
        return this.levels;
    }

    public String getLevels(int defaultLevel) {
        if (this.levels == null) {
            StringBuilder b = new StringBuilder();
            String l = EncodedPolylineBean.encodeNumber(defaultLevel);
            for (int i = 0; i < this.length; ++i) {
                b.append(l);
            }
            return b.toString();
        }
        return this.levels;
    }

    public void setLevels(String levels) {
        this.levels = levels;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    private static String encodeNumber(int num) {
        StringBuffer encodeString = new StringBuffer();
        while (num >= 32) {
            int nextValue = (0x20 | num & 0x1F) + 63;
            encodeString.append((char)nextValue);
            num >>= 5;
        }
        encodeString.append((char)(num += 63));
        return encodeString.toString();
    }
}

