/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.geospatial.model;

import java.io.Serializable;
import org.onebusaway.geospatial.model.CoordinatePoint;

public final class CoordinateBounds
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean _empty = true;
    private double _minLat;
    private double _minLon;
    private double _maxLat;
    private double _maxLon;

    public CoordinateBounds() {
    }

    public CoordinateBounds(double lat, double lon) {
        this.addPoint(lat, lon);
    }

    public CoordinateBounds(CoordinateBounds bounds) {
        this.addBounds(bounds);
    }

    public CoordinateBounds(double minLat, double minLon, double maxLat, double maxLon) {
        this.addPoint(minLat, minLon);
        this.addPoint(maxLat, maxLon);
    }

    public boolean isEmpty() {
        return this._empty;
    }

    public void setEmpty(boolean empty) {
        this._empty = empty;
    }

    public double getMinLat() {
        return this._minLat;
    }

    public void setMinLat(double minLat) {
        this._minLat = minLat;
    }

    public double getMinLon() {
        return this._minLon;
    }

    public void setMinLon(double minLon) {
        this._minLon = minLon;
    }

    public double getMaxLat() {
        return this._maxLat;
    }

    public void setMaxLat(double maxLat) {
        this._maxLat = maxLat;
    }

    public double getMaxLon() {
        return this._maxLon;
    }

    public void setMaxLon(double maxLon) {
        this._maxLon = maxLon;
    }

    public void addPoint(double lat, double lon) {
        if (this._empty) {
            this._empty = false;
            this._minLat = lat;
            this._minLon = lon;
            this._maxLat = lat;
            this._maxLon = lon;
        } else {
            this._minLat = Math.min(this._minLat, lat);
            this._minLon = Math.min(this._minLon, lon);
            this._maxLat = Math.max(this._maxLat, lat);
            this._maxLon = Math.max(this._maxLon, lon);
        }
    }

    public void addBounds(CoordinateBounds bounds) {
        this.addPoint(bounds.getMinLat(), bounds.getMinLon());
        this.addPoint(bounds.getMaxLat(), bounds.getMaxLon());
    }

    public void clear() {
        this._empty = true;
    }

    public boolean contains(double lat, double lon) {
        return this._minLat <= lat && lat <= this._maxLat && this._minLon <= lon && lon <= this._maxLon;
    }

    public boolean contains(CoordinatePoint point) {
        return this.contains(point.getLat(), point.getLon());
    }

    public boolean intersects(CoordinateBounds r) {
        double minLat = Math.max(this._minLat, r._minLat);
        double minLon = Math.max(this._minLon, r._minLon);
        double maxLat = Math.min(this._maxLat, r._maxLat);
        double maxLon = Math.min(this._maxLon, r._maxLon);
        return minLat <= maxLat && minLon <= maxLon;
    }

    public CoordinateBounds intersection(CoordinateBounds r) {
        double minLat = Math.max(this._minLat, r._minLat);
        double minLon = Math.max(this._minLon, r._minLon);
        double maxLat = Math.min(this._maxLat, r._maxLat);
        double maxLon = Math.min(this._maxLon, r._maxLon);
        return new CoordinateBounds(minLat, minLon, maxLat, maxLon);
    }

    public CoordinateBounds union(CoordinateBounds r) {
        double minLat = Math.min(this._minLat, r._minLat);
        double minLon = Math.min(this._minLon, r._minLon);
        double maxLat = Math.max(this._maxLat, r._maxLat);
        double maxLon = Math.max(this._maxLon, r._maxLon);
        return new CoordinateBounds(minLat, minLon, maxLat, maxLon);
    }

    public String toString() {
        return this._minLat + "," + this._minLon + "," + this._maxLat + "," + this._maxLon;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._empty ? 1231 : 1237);
        result = 31 * result + Double.valueOf(this._maxLat).hashCode();
        result = 31 * result + Double.valueOf(this._maxLon).hashCode();
        result = 31 * result + Double.valueOf(this._minLat).hashCode();
        result = 31 * result + Double.valueOf(this._minLon).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoordinateBounds)) {
            return false;
        }
        CoordinateBounds other = (CoordinateBounds)obj;
        if (this._empty != other._empty) {
            return false;
        }
        if (this._maxLat != other._maxLat) {
            return false;
        }
        if (this._maxLon != other._maxLon) {
            return false;
        }
        if (this._minLat != other._minLat) {
            return false;
        }
        return this._minLon == other._minLon;
    }
}

