/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.geospatial;

import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.STRtree;
import org.onebusaway.geospatial.HierarchicalSTRtree;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;

public class HierarchicalSTRtreeFactory<T> {
    private Map<CoordinateBounds, STRtree> _treesByBounds = new HashMap<CoordinateBounds, STRtree>();
    private double _latStep = 0.0;
    private double _lonStep = 0.0;

    public void setLatStep(double latStep) {
        this._latStep = latStep;
    }

    public void setLonStep(double lonStep) {
        this._lonStep = lonStep;
    }

    public void setLatAndLonStep(double lat, double lon, double gridSize) {
        CoordinateBounds b = SphericalGeometryLibrary.bounds(lat, lon, gridSize / 2.0);
        this._latStep = b.getMaxLat() - b.getMinLat();
        this._lonStep = b.getMaxLon() - b.getMinLon();
    }

    public void add(double lat, double lon, T element) {
        STRtree tree = null;
        for (Map.Entry<CoordinateBounds, STRtree> entry : this._treesByBounds.entrySet()) {
            CoordinateBounds bounds = entry.getKey();
            if (!bounds.contains(lat, lon)) continue;
            tree = entry.getValue();
            break;
        }
        if (tree == null) {
            double gLat = Math.floor(lat / this._latStep) * this._latStep;
            double gLon = Math.floor(lon / this._lonStep) * this._lonStep;
            CoordinateBounds b = new CoordinateBounds(gLat, gLon, gLat + this._latStep, gLon + this._lonStep);
            tree = new STRtree();
            this._treesByBounds.put(b, tree);
        }
        Envelope env = new Envelope(lon, lon, lat, lat);
        tree.insert(env, element);
    }

    public HierarchicalSTRtree<T> create() {
        STRtree parentTree = new STRtree();
        for (Map.Entry<CoordinateBounds, STRtree> entry : this._treesByBounds.entrySet()) {
            CoordinateBounds b = entry.getKey();
            Envelope env = new Envelope(b.getMinLon(), b.getMaxLon(), b.getMinLat(), b.getMaxLat());
            STRtree tree = entry.getValue();
            tree.build();
            parentTree.insert(env, (Object)tree);
        }
        parentTree.build();
        return new HierarchicalSTRtree(parentTree);
    }
}

