/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.cloud.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.MultipleFileUpload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.cloud.aws.CredentialContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Services {
    private final Logger _log = LoggerFactory.getLogger(S3Services.class);
    Map<CredentialContainer, AmazonS3> regionMap = new HashMap<CredentialContainer, AmazonS3>();
    TransferManager tm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AmazonS3 getS3Provider(CredentialContainer cc) {
        String profile;
        if (cc == null) {
            cc = CredentialContainer.getDefault();
        }
        if ((profile = cc.getProfile()) == null || profile.equals("")) {
            this._log.error("profile must be set:  profile=|" + profile + "|");
            throw new IllegalStateException("profile must be set:  profile=|" + profile + "|");
        }
        String region = cc.getRegion();
        Map<CredentialContainer, AmazonS3> map = this.regionMap;
        synchronized (map) {
            if (this.regionMap.get(cc) == null) {
                AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new ProfileCredentialsProvider(profile))).withRegion(region)).build();
                this.regionMap.put(cc, s3);
            }
        }
        AmazonS3 result = this.regionMap.get(cc);
        return result;
    }

    private TransferManager getTransferManager() {
        if (this.tm == null) {
            this.tm = TransferManagerBuilder.defaultTransferManager();
        }
        return this.tm;
    }

    public S3ObjectInputStream fetch(String url, CredentialContainer profile) {
        if (profile == null) {
            throw new IllegalStateException("profile cannot be null!");
        }
        this._log.info("fetching " + url + " with profile " + profile.getProfile());
        AmazonS3URI uri = new AmazonS3URI(url);
        S3Object o = this.getS3Provider(profile).getObject(uri.getBucket(), uri.getKey());
        return o.getObjectContent();
    }

    public String fetch(String url, String toFileName, String destinationPath, CredentialContainer profile) {
        this._log.info("fetching " + url + " to " + destinationPath + " with profile " + profile.toString());
        S3ObjectInputStream s3is = this.fetch(url, profile);
        File mkdir = new File(destinationPath);
        if (!mkdir.exists() || !mkdir.isDirectory()) {
            mkdir.mkdirs();
        }
        String destinationFileName = destinationPath + File.separator + toFileName;
        try {
            FileOutputStream fos = new FileOutputStream(new File(destinationFileName));
            byte[] read_buf = new byte[1024];
            int read_len = 0;
            while ((read_len = s3is.read(read_buf)) > 0) {
                fos.write(read_buf, 0, read_len);
            }
            s3is.close();
            fos.close();
        }
        catch (IOException ioe) {
            this._log.error("unable to write {} to {}", (Object)url, (Object)destinationFileName);
            destinationFileName = null;
        }
        return destinationFileName;
    }

    public boolean put(String url, String fileName) {
        this._log.info("uploading {} to {}", (Object)fileName, (Object)url);
        AmazonS3URI uri = new AmazonS3URI(url);
        this.getS3Provider(null).putObject(uri.getBucket(), uri.getKey(), new File(fileName));
        return true;
    }

    public boolean putRecursively(String url, String directoryName) {
        this._log.info("uploading (recursively) {} to {}", (Object)directoryName, (Object)url);
        try {
            AmazonS3URI uri = new AmazonS3URI(url);
            MultipleFileUpload upload = this.getTransferManager().uploadDirectory(uri.getBucket(), uri.getKey(), new File(directoryName), true);
            upload.waitForCompletion();
            this._log.info("upload complete!");
        }
        catch (Exception any) {
            this._log.error("upload failed: ", (Throwable)any);
            return false;
        }
        return true;
    }
}

