/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.cloud.aws;

import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.onebusaway.cloud.api.Credential;
import org.onebusaway.cloud.api.ExternalResult;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.InputStreamConsumer;
import org.onebusaway.cloud.aws.AwsExternalResult;
import org.onebusaway.cloud.aws.AwsLeadershipElectionService;
import org.onebusaway.cloud.aws.CloudWatchServices;
import org.onebusaway.cloud.aws.CredentialContainer;
import org.onebusaway.cloud.aws.S3Services;
import org.onebusaway.cloud.aws.SNSServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalServicesAws
implements ExternalServices {
    private Logger _log = LoggerFactory.getLogger(ExternalServicesAws.class);
    private SNSServices _sns = new SNSServices();
    private CloudWatchServices _cloudwatch = new CloudWatchServices();
    private S3Services _s3 = new S3Services();
    private AwsLeadershipElectionService _election = new AwsLeadershipElectionService();

    public ExternalResult publishMessage(String topic, String messageConents) {
        boolean result = this._sns.publish(topic, messageConents);
        return new AwsExternalResult(result);
    }

    public ExternalResult publishMetric(String namespace, String metricName, String dimensionName, String dimensionValue, double value) {
        return this._cloudwatch.publishMetric(namespace, metricName, dimensionName, dimensionValue, value);
    }

    public ExternalResult publishMetric(Credential credential, String namespace, String metricName, String dimensionName, String dimensionValue, double value) {
        return this._cloudwatch.publishMetric(credential, namespace, metricName, dimensionName, dimensionValue, value);
    }

    public ExternalResult publishMetrics(Credential credential, String namespace, List<String> metricNames, List<String> dimensionNames, List<String> dimensionValues, List<Double> values) {
        return this._cloudwatch.publishMetrics(credential, namespace, metricNames, dimensionNames, dimensionValues, values);
    }

    public ExternalResult publishMetrics(String namespace, List<String> metricNames, List<String> dimensionNames, List<String> dimensionValues, List<Double> values) {
        return this._cloudwatch.publishMetrics(namespace, metricNames, dimensionNames, dimensionValues, values);
    }

    public ExternalResult publishMultiDimensionalMetric(Credential credential, String namespace, String metricName, String[] dimensionName, String[] dimensionValue, double value) {
        return this._cloudwatch.publishMultiDimensionalMetric(credential, namespace, metricName, dimensionName, dimensionValue, value);
    }

    public ExternalResult publishMultiDimensionalMetric(String namespace, String metricName, String[] dimensionName, String[] dimensionValue, double value) {
        return this.publishMultiDimensionalMetric(new CredentialContainer().getDefaultCredential(), namespace, metricName, dimensionName, dimensionValue, value);
    }

    public ExternalResult getFileAsStream(String url, InputStreamConsumer consumer) {
        return this.getFileAsStream(url, consumer, null);
    }

    public ExternalResult getFileAsStream(String url, InputStreamConsumer consumer, String profile) {
        return this.getFileAsStream(url, consumer, profile, "us-east-1");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExternalResult getFileAsStream(String url, InputStreamConsumer consumer, String profile, String region) {
        CredentialContainer credentials = profile == null || "default".equals(profile) ? new CredentialContainer() : new CredentialContainer(profile, region);
        try (S3ObjectInputStream inputStream = this._s3.fetch(url, credentials);){
            consumer.accept((InputStream)inputStream);
            AwsExternalResult awsExternalResult = new AwsExternalResult(true);
            return awsExternalResult;
        }
        catch (IOException ex) {
            this._log.error("Error reading from S3: {}", (Throwable)ex);
            ex.printStackTrace();
            return new AwsExternalResult(false, ex.toString(), null);
        }
    }

    public boolean isInstancePrimary() {
        return this._election.isInstancePrimary();
    }
}

