/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.cloud.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataResult;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.cloud.api.Credential;
import org.onebusaway.cloud.api.ExternalResult;
import org.onebusaway.cloud.aws.AwsExternalResult;
import org.onebusaway.cloud.aws.CredentialContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchServices {
    private final Logger _log = LoggerFactory.getLogger(CloudWatchServices.class);
    private static final int MAX_DATUM_LENGTH = 20;
    Map<Credential, AmazonCloudWatch> _clientMap = new HashMap<Credential, AmazonCloudWatch>();

    public ExternalResult publishMetric(String namespace, String metricName, String dimensionName, String dimensionValue, double value) {
        return this.publishMetric(new CredentialContainer().getDefaultCredential(), namespace, metricName, dimensionName, dimensionValue, value);
    }

    public ExternalResult publishMetric(Credential credential, String namespace, String metricName, String dimensionName, String dimensionValue, double value) {
        ArrayList<Dimension> dims = null;
        if (dimensionName != null && dimensionValue != null) {
            dims = new ArrayList<Dimension>(1);
            Dimension dim = new Dimension().withName(dimensionName).withValue(dimensionValue);
            dims.add(dim);
        }
        MetricDatum metricDatum = this.getMetricAsMetricDatum(metricName, dims, value);
        return this.publishMetric(credential, namespace, metricDatum);
    }

    public ExternalResult publishMultiDimensionalMetric(String namespace, String metricName, String[] dimensionName, String[] dimensionValue, double value) {
        return this.publishMultiDimensionalMetric(new CredentialContainer().getDefaultCredential(), namespace, metricName, dimensionName, dimensionValue, value);
    }

    public ExternalResult publishMultiDimensionalMetric(Credential credential, String namespace, String metricName, String[] dimensionName, String[] dimensionValue, double value) {
        ArrayList<Dimension> dims = null;
        if (dimensionName != null && dimensionValue != null) {
            if (dimensionName.length != dimensionValue.length) {
                throw new IllegalStateException("Input array lengths must match: " + dimensionName + " vs " + dimensionValue);
            }
            dims = new ArrayList<Dimension>(1);
            for (int i = 0; i < dimensionName.length; ++i) {
                if (dimensionName[i] == null || dimensionValue[i] == null) continue;
                Dimension dim = new Dimension().withName(dimensionName[i]).withValue(dimensionValue[i]);
                dims.add(dim);
            }
        } else if (dimensionName != dimensionValue) {
            throw new IllegalStateException("Dimension mismatch: name=" + dimensionName + " vs value=" + dimensionValue);
        }
        MetricDatum metricDatum = this.getMetricAsMetricDatum(metricName, dims, value);
        return this.publishMetric(credential, namespace, metricDatum);
    }

    public ExternalResult publishMetrics(String namespace, List<String> metricNames, List<String> dimensionNames, List<String> dimensionValues, List<Double> values) {
        return this.publishMetrics(new CredentialContainer().getDefaultCredential(), namespace, metricNames, dimensionNames, dimensionValues, values);
    }

    public ExternalResult publishMetrics(Credential credential, String namespace, List<String> metricNames, List<String> dimensionNames, List<String> dimensionValues, List<Double> values) {
        if (metricNames == null || values == null) {
            throw new IllegalStateException("Invalid input: metricNames=" + metricNames + " and values=" + values);
        }
        if (metricNames.size() != values.size()) {
            throw new IllegalStateException("Input array lengths must match: metricNames=" + metricNames.size() + " vs values " + values.size());
        }
        if (dimensionNames != null && dimensionValues != null && dimensionNames.size() != metricNames.size() || dimensionValues.size() != metricNames.size()) {
            throw new IllegalStateException("Input array lengths must match: dimensionNames=" + metricNames.size() + " vs dimensionValues " + dimensionValues.size());
        }
        MetricDatum[] metricDatums = new MetricDatum[metricNames.size()];
        for (int i = 0; i < metricNames.size(); ++i) {
            MetricDatum metricDatum;
            ArrayList<Dimension> dims = null;
            if (dimensionNames != null && dimensionValues != null) {
                dims = new ArrayList<Dimension>(1);
                Dimension dim = new Dimension().withName(dimensionNames.get(i)).withValue(dimensionValues.get(i));
                dims.add(dim);
            }
            metricDatums[i] = metricDatum = this.getMetricAsMetricDatum(metricNames.get(i), dims, values.get(i));
        }
        if (metricDatums.length > 20) {
            ExternalResult lastResult = null;
            List<MetricDatum[]> metricData = this.splitArray(metricDatums, 20);
            for (MetricDatum[] metricDatum : metricData) {
                lastResult = this.publishMetric(credential, namespace, metricDatum);
            }
            return lastResult;
        }
        return this.publishMetric(credential, namespace, metricDatums);
    }

    private MetricDatum getMetricAsMetricDatum(String metricName, List<Dimension> dims, double value) {
        MetricDatum datum = new MetricDatum().withMetricName(metricName).withValue(Double.valueOf(value)).withUnit(StandardUnit.Count);
        if (dims != null) {
            if (datum.getDimensions() == null) {
                datum.setDimensions(new ArrayList());
            }
            datum.getDimensions().addAll(dims);
        }
        return datum;
    }

    public ExternalResult publishMetric(String namespace, MetricDatum ... datum) {
        return this.publishMetric(new CredentialContainer().getDefaultCredential(), namespace, datum);
    }

    public ExternalResult publishMetric(Credential credential, String namespace, MetricDatum ... datum) {
        PutMetricDataRequest pmdr = new PutMetricDataRequest().withNamespace(namespace).withMetricData(datum);
        for (MetricDatum md : datum) {
            this._log.debug("cloudwatch(" + namespace + ":" + md.getMetricName() + " (" + md.getDimensions() + ")  " + md.getValue() + ")");
        }
        PutMetricDataResult result = this.getClient(credential).putMetricData(pmdr);
        return new AwsExternalResult(true, result.toString(), null);
    }

    private <T> List<T[]> splitArray(T[] array, int splitSize) {
        int numberOfArrays = array.length / splitSize;
        int remainder = array.length % splitSize;
        int start = 0;
        int end = 0;
        ArrayList<T[]> list = new ArrayList<T[]>();
        for (int i = 0; i < numberOfArrays; ++i) {
            list.add(Arrays.copyOfRange(array, start, end += splitSize));
            start = end;
        }
        if (remainder > 0) {
            list.add(Arrays.copyOfRange(array, start, start + remainder));
        }
        return list;
    }

    private AmazonCloudWatch getClient(Credential credential) {
        if (this._clientMap.get(credential) == null) {
            this._clientMap.put(credential, (AmazonCloudWatch)((AmazonCloudWatchClientBuilder)((AmazonCloudWatchClientBuilder)AmazonCloudWatchClientBuilder.standard().withCredentials((AWSCredentialsProvider)new ProfileCredentialsProvider(credential.getKey()))).withRegion(credential.getValue())).build());
        }
        return this._clientMap.get(credential);
    }
}

