/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.cloud.aws;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClientBuilder;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.util.EC2MetadataUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsLeadershipElectionService {
    private static Logger _log = LoggerFactory.getLogger(AwsLeadershipElectionService.class);
    private boolean _primary = true;
    private ScheduledExecutorService _scheduledExecutorService;

    public boolean isInstancePrimary() {
        String autoScalingGroupName = System.getProperty("aws.autoScalingGroup");
        if (autoScalingGroupName == null) {
            return true;
        }
        this.scheduleTaskIfUnscheduled(autoScalingGroupName);
        return this._primary;
    }

    private void scheduleTaskIfUnscheduled(String autoScalingGroupName) {
        if (this._scheduledExecutorService == null) {
            try {
                _log.info("scheduling primary check for group " + autoScalingGroupName);
                this._scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
                this._scheduledExecutorService.scheduleAtFixedRate(new LeadershipElectionTask(autoScalingGroupName), 1L, 1L, TimeUnit.MINUTES);
                new LeadershipElectionTask(autoScalingGroupName).run();
            }
            catch (Throwable any) {
                _log.error("exception scheduling primary check: " + any, any);
            }
        }
    }

    private class LeadershipElectionTask
    implements Runnable {
        private AmazonAutoScaling _autoScale;
        private AmazonEC2 _ec2;
        private String _autoScalingGroupName;

        public LeadershipElectionTask(String autoScalingGroupName) {
            try {
                this._ec2 = (AmazonEC2)AmazonEC2ClientBuilder.standard().build();
                this._autoScale = (AmazonAutoScaling)AmazonAutoScalingClientBuilder.standard().build();
                this._autoScalingGroupName = autoScalingGroupName;
            }
            catch (Throwable e) {
                _log.warn("Unable to create AWS Clients", e);
            }
        }

        @Override
        public void run() {
            block6: {
                AutoScalingGroup autoScalingGroup = this.getAutoScalingGroups();
                if (autoScalingGroup != null) {
                    try {
                        String oldestInstance = null;
                        Date oldestInstanceLaunchTime = new Date();
                        List<String> instanceIds = autoScalingGroup.getInstances().stream().map(Instance::getInstanceId).collect(Collectors.toList());
                        List<com.amazonaws.services.ec2.model.Instance> instances = this.getInstances(instanceIds);
                        for (com.amazonaws.services.ec2.model.Instance instance : instances) {
                            if (!instance.getLaunchTime().before(oldestInstanceLaunchTime)) continue;
                            oldestInstanceLaunchTime = instance.getLaunchTime();
                            oldestInstance = instance.getInstanceId();
                        }
                        if (oldestInstance != null && oldestInstance.equals(EC2MetadataUtils.getInstanceId())) {
                            _log.warn("This is the primary instance.");
                            AwsLeadershipElectionService.this._primary = true;
                            break block6;
                        }
                        _log.warn("This is not the primary instance. Oldest Instance Id is {}, this Instance Id is {}", (Object)oldestInstance, (Object)EC2MetadataUtils.getInstanceId());
                        AwsLeadershipElectionService.this._primary = false;
                    }
                    catch (Throwable any) {
                        _log.error("exception with primary check:" + any, any);
                    }
                } else {
                    _log.warn("Not the primary instance, no autoScaling group found.");
                    AwsLeadershipElectionService.this._primary = false;
                }
            }
        }

        private AutoScalingGroup getAutoScalingGroups() {
            try {
                DescribeAutoScalingGroupsResult result = this._autoScale.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest());
                return result.getAutoScalingGroups().stream().filter(group -> group.getAutoScalingGroupName().startsWith(this._autoScalingGroupName)).findFirst().orElse(null);
            }
            catch (Throwable any) {
                _log.error("exception retrieving autoscaling groups " + any, any);
                return null;
            }
        }

        private List<com.amazonaws.services.ec2.model.Instance> getInstances(List<String> instanceIds) {
            try {
                DescribeInstancesRequest request = new DescribeInstancesRequest();
                request.setInstanceIds(instanceIds);
                DescribeInstancesResult result = this._ec2.describeInstances(request);
                ArrayList<com.amazonaws.services.ec2.model.Instance> instances = new ArrayList<com.amazonaws.services.ec2.model.Instance>();
                for (Reservation reservation : result.getReservations()) {
                    instances.addAll(reservation.getInstances());
                }
                return instances;
            }
            catch (Throwable e) {
                _log.error("Unable to retreive instances", e);
                return Collections.EMPTY_LIST;
            }
        }
    }
}

