/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityWriter;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.gtfs.impl.ZipHandler;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.services.GtfsDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsWriter
extends CsvEntityWriter {
    private final Logger _log = LoggerFactory.getLogger(GtfsWriter.class);
    public static final String KEY_CONTEXT = GtfsWriter.class.getName() + ".context";
    private List<Class<?>> _entityClasses = new ArrayList();
    private File _outputLocation = null;
    private Map<Class<?>, Comparator<?>> _entityComparators = new HashMap();

    public void setOutputLocation(File path) {
        super.setOutputLocation(path);
        this._outputLocation = path;
    }

    public GtfsWriter() {
        this._entityClasses.addAll(GtfsEntitySchemaFactory.getEntityClasses());
        this._entityComparators.putAll(GtfsEntitySchemaFactory.getEntityComparators());
        DefaultEntitySchemaFactory schemaFactory = this.createEntitySchemaFactory();
        this.setEntitySchemaFactory((EntitySchemaFactory)schemaFactory);
    }

    public List<Class<?>> getEntityClasses() {
        return this._entityClasses;
    }

    public Map<Class<?>, Comparator<?>> getEntityComparators() {
        return this._entityComparators;
    }

    public void run(GtfsDao dao) throws IOException {
        List<Class<?>> classes = this.getEntityClasses();
        for (Class<?> entityClass : classes) {
            this._log.info("writing entities: " + entityClass.getName());
            Collection<Object> entities = this.sortEntities(entityClass, dao.getAllEntitiesForType(entityClass));
            this.excludeOptionalAndMissingFields(entityClass, entities);
            for (Object entity : entities) {
                this.handleEntity(entity);
            }
            this.flush();
        }
        this.close();
        List<String> filenames = dao.getOptionalMetadataFilenames();
        for (String metadataFile : filenames) {
            if (!dao.hasMetadata(metadataFile)) continue;
            this._log.info("writing metadata file : " + metadataFile);
            this.writeContent(metadataFile, dao.getMetadata(metadataFile));
        }
    }

    private void writeContent(String srcFilename, String content) {
        if (content == null) {
            return;
        }
        if (this._outputLocation.getName().endsWith(".zip")) {
            this.copyToZipFile(srcFilename, content);
        } else {
            try {
                String location = this._outputLocation.getAbsolutePath() + File.separator + srcFilename;
                FileWriter fw = new FileWriter(location);
                fw.write(content);
                fw.close();
            }
            catch (IOException e) {
                System.err.println("issue copying metadata: " + e);
            }
        }
    }

    private void copyToZipFile(String srcFilename, String content) {
        try {
            new ZipHandler(this._outputLocation).writeTextToFile(srcFilename, content);
        }
        catch (IOException e) {
            System.err.println("issue copying metadata to zipfile: " + e);
        }
    }

    private Collection<Object> sortEntities(Class<?> entityClass, Collection<?> entities) {
        Comparator<?> comparator = this._entityComparators.get(entityClass);
        if (comparator == null) {
            return entities;
        }
        ArrayList<Object> sorted = new ArrayList<Object>();
        sorted.addAll(entities);
        Collections.sort(sorted, comparator);
        return sorted;
    }

    protected DefaultEntitySchemaFactory createEntitySchemaFactory() {
        return GtfsEntitySchemaFactory.createEntitySchemaFactory();
    }
}

