/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.CsvEntityReader;
import org.onebusaway.csv_entities.CsvInputSource;
import org.onebusaway.csv_entities.CsvTokenizerStrategy;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.csv_entities.TokenizerStrategy;
import org.onebusaway.csv_entities.exceptions.CsvEntityIOException;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.gtfs.impl.GtfsDaoImpl;
import org.onebusaway.gtfs.impl.ZipHandler;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.AlternateStopNameException;
import org.onebusaway.gtfs.model.Area;
import org.onebusaway.gtfs.model.Block;
import org.onebusaway.gtfs.model.BookingRule;
import org.onebusaway.gtfs.model.DirectionEntry;
import org.onebusaway.gtfs.model.DirectionNameException;
import org.onebusaway.gtfs.model.Facility;
import org.onebusaway.gtfs.model.FacilityProperty;
import org.onebusaway.gtfs.model.FacilityPropertyDefinition;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareLegRule;
import org.onebusaway.gtfs.model.FareMedium;
import org.onebusaway.gtfs.model.FareProduct;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.FareTransferRule;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Level;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.LocationGroupElement;
import org.onebusaway.gtfs.model.Note;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.RiderCategory;
import org.onebusaway.gtfs.model.Ridership;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.RouteNameException;
import org.onebusaway.gtfs.model.RouteShape;
import org.onebusaway.gtfs.model.RouteStop;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopArea;
import org.onebusaway.gtfs.model.StopAreaElement;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Translation;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.Vehicle;
import org.onebusaway.gtfs.model.WrongWayConcurrency;
import org.onebusaway.gtfs.serialization.DuplicateEntityException;
import org.onebusaway.gtfs.serialization.EntityReferenceNotFoundException;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;
import org.onebusaway.gtfs.serialization.LocationsGeoJSONReader;
import org.onebusaway.gtfs.serialization.NoDefaultAgencyIdException;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsReader
extends CsvEntityReader {
    private final Logger _log = LoggerFactory.getLogger(GtfsReader.class);
    public static final String KEY_CONTEXT = GtfsReader.class.getName() + ".context";
    private List<Class<?>> _entityClasses = new ArrayList();
    private GtfsReaderContextImpl _context = new GtfsReaderContextImpl();
    private GenericMutableDao _entityStore = new GtfsDaoImpl();
    private List<Agency> _agencies = new ArrayList<Agency>();
    private Map<Class<?>, Map<String, String>> _agencyIdsByEntityClassAndId = new HashMap();
    private String _defaultAgencyId;
    private Map<String, String> _agencyIdMapping = new HashMap<String, String>();
    private boolean _overwriteDuplicates = false;
    private File _inputLocation = null;

    public GtfsReader() {
        this._entityClasses.add(Agency.class);
        this._entityClasses.add(Block.class);
        this._entityClasses.add(ShapePoint.class);
        this._entityClasses.add(Note.class);
        this._entityClasses.add(Area.class);
        this._entityClasses.add(BookingRule.class);
        this._entityClasses.add(Route.class);
        this._entityClasses.add(RouteStop.class);
        this._entityClasses.add(RouteShape.class);
        this._entityClasses.add(Level.class);
        this._entityClasses.add(Stop.class);
        this._entityClasses.add(Location.class);
        this._entityClasses.add(LocationGroup.class);
        this._entityClasses.add(LocationGroupElement.class);
        this._entityClasses.add(Trip.class);
        this._entityClasses.add(StopAreaElement.class);
        this._entityClasses.add(StopTime.class);
        this._entityClasses.add(ServiceCalendar.class);
        this._entityClasses.add(ServiceCalendarDate.class);
        this._entityClasses.add(RiderCategory.class);
        this._entityClasses.add(FareMedium.class);
        this._entityClasses.add(FareProduct.class);
        this._entityClasses.add(FareLegRule.class);
        this._entityClasses.add(FareAttribute.class);
        this._entityClasses.add(FareRule.class);
        this._entityClasses.add(FareTransferRule.class);
        this._entityClasses.add(Frequency.class);
        this._entityClasses.add(Pathway.class);
        this._entityClasses.add(Transfer.class);
        this._entityClasses.add(FeedInfo.class);
        this._entityClasses.add(Ridership.class);
        this._entityClasses.add(Translation.class);
        this._entityClasses.add(Vehicle.class);
        this._entityClasses.add(Facility.class);
        this._entityClasses.add(FacilityPropertyDefinition.class);
        this._entityClasses.add(FacilityProperty.class);
        this._entityClasses.add(RouteNameException.class);
        this._entityClasses.add(DirectionNameException.class);
        this._entityClasses.add(WrongWayConcurrency.class);
        this._entityClasses.add(DirectionEntry.class);
        this._entityClasses.add(AlternateStopNameException.class);
        CsvTokenizerStrategy tokenizerStrategy = new CsvTokenizerStrategy();
        tokenizerStrategy.getCsvParser().setTrimInitialWhitespace(true);
        this.setTokenizerStrategy((TokenizerStrategy)tokenizerStrategy);
        this.setTrimValues(true);
        DefaultEntitySchemaFactory schemaFactory = this.createEntitySchemaFactory();
        this.setEntitySchemaFactory((EntitySchemaFactory)schemaFactory);
        CsvEntityContext ctx = this.getContext();
        ctx.put((Object)KEY_CONTEXT, (Object)this._context);
        this.addEntityHandler(new EntityHandlerImpl());
    }

    public void setInputLocation(File path) throws IOException {
        super.setInputLocation(path);
        this._inputLocation = path;
    }

    public void setLastModifiedTime(Long lastModifiedTime) {
        if (lastModifiedTime != null) {
            this.getContext().put((Object)"lastModifiedTime", (Object)lastModifiedTime);
        }
    }

    public Long getLastModfiedTime() {
        return (Long)this.getContext().get((Object)"lastModifiedTime");
    }

    public List<Agency> getAgencies() {
        return this._agencies;
    }

    public void setAgencies(List<Agency> agencies) {
        this._agencies = new ArrayList<Agency>(agencies);
    }

    public void setDefaultAgencyId(String feedId) {
        this._defaultAgencyId = feedId;
    }

    public String getDefaultAgencyId() {
        if (this._defaultAgencyId != null) {
            return this._defaultAgencyId;
        }
        if (this._agencies.size() > 0) {
            return this._agencies.get(0).getId();
        }
        throw new NoDefaultAgencyIdException();
    }

    public void addAgencyIdMapping(String fromAgencyId, String toAgencyId) {
        this._agencyIdMapping.put(fromAgencyId, toAgencyId);
    }

    public GtfsReaderContext getGtfsReaderContext() {
        return this._context;
    }

    public GenericMutableDao getEntityStore() {
        return this._entityStore;
    }

    public void setEntityStore(GenericMutableDao entityStore) {
        this._entityStore = entityStore;
    }

    public List<Class<?>> getEntityClasses() {
        return this._entityClasses;
    }

    public void setEntityClasses(List<Class<?>> entityClasses) {
        this._entityClasses = entityClasses;
    }

    public void setOverwriteDuplicates(boolean overwriteDuplicates) {
        this._overwriteDuplicates = overwriteDuplicates;
    }

    public void readEntities(Class<?> entityClass, Reader reader) throws IOException, CsvEntityIOException {
        if (entityClass == Location.class) {
            for (Location location : new LocationsGeoJSONReader(reader, this.getDefaultAgencyId()).read()) {
                this.injectEntity(location);
            }
        } else {
            super.readEntities(entityClass, reader);
        }
    }

    public void run() throws IOException {
        this.run(this.getInputSource());
    }

    public void run(CsvInputSource source) throws IOException {
        List<String> filenames;
        List<Class<?>> classes = this.getEntityClasses();
        this._entityStore.open();
        for (Class<?> entityClass : classes) {
            this._log.info("reading entities: " + entityClass.getName());
            this.readEntities(entityClass, source);
            this._entityStore.flush();
        }
        this._entityStore.close();
        if (this._entityStore instanceof GtfsDaoImpl && (filenames = ((GtfsDaoImpl)this._entityStore).getOptionalMetadataFilenames()) != null) {
            for (String metaFile : filenames) {
                if (!source.hasResource(metaFile)) continue;
                this._log.info("reading metadata file: " + metaFile);
                ((GtfsDaoImpl)this._entityStore).addMetadata(metaFile, this.readContent(this._inputLocation, metaFile));
            }
        }
    }

    private String readContent(File inputLocation, String filename) {
        if (inputLocation.getAbsoluteFile().getName().endsWith(".zip")) {
            return this.readContentFromZip(inputLocation, filename);
        }
        return this.readContentFromFile(new File(inputLocation.getAbsolutePath() + File.separator + filename));
    }

    private String readContentFromFile(File filePath) {
        StringBuffer sb = new StringBuffer();
        try {
            byte[] bytes = Files.readAllBytes(filePath.toPath());
            sb.append(new String(bytes, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            System.err.println("issue reading content from " + filePath);
        }
        return sb.toString();
    }

    private String readContentFromZip(File zipFilePath, String zipEntryName) {
        try {
            ZipHandler zip = new ZipHandler(zipFilePath);
            return zip.readTextFromFile(zipEntryName);
        }
        catch (IOException e) {
            System.err.println("issue reading content from " + zipFilePath + ":" + zipEntryName);
            return null;
        }
    }

    protected DefaultEntitySchemaFactory createEntitySchemaFactory() {
        return GtfsEntitySchemaFactory.createEntitySchemaFactory();
    }

    protected Object getEntity(Class<?> entityClass, Serializable id) {
        if (entityClass == null) {
            throw new IllegalArgumentException("entity class must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("entity id must not be null");
        }
        return this._entityStore.getEntityForId(entityClass, id);
    }

    protected String getTranslatedAgencyId(String agencyId) {
        String id = this._agencyIdMapping.get(agencyId);
        if (id != null) {
            return id;
        }
        return agencyId;
    }

    protected String getAgencyForEntity(Class<?> entityType, String entityId) {
        String id;
        Map<String, String> agencyIdsByEntityId = this._agencyIdsByEntityClassAndId.get(entityType);
        if (agencyIdsByEntityId != null && (id = agencyIdsByEntityId.get(entityId)) != null) {
            return id;
        }
        throw new EntityReferenceNotFoundException(entityType, entityId);
    }

    private class GtfsReaderContextImpl
    implements GtfsReaderContext {
        private GtfsReaderContextImpl() {
        }

        @Override
        public Object getEntity(Class<?> entityClass, Serializable id) {
            return GtfsReader.this.getEntity(entityClass, id);
        }

        @Override
        public String getDefaultAgencyId() {
            return GtfsReader.this.getDefaultAgencyId();
        }

        @Override
        public List<Agency> getAgencies() {
            return GtfsReader.this.getAgencies();
        }

        @Override
        public String getAgencyForEntity(Class<?> entityType, String entityId) {
            return GtfsReader.this.getAgencyForEntity(entityType, entityId);
        }

        @Override
        public String getTranslatedAgencyId(String agencyId) {
            return GtfsReader.this.getTranslatedAgencyId(agencyId);
        }
    }

    private class EntityHandlerImpl
    implements EntityHandler {
        private EntityHandlerImpl() {
        }

        public void handleEntity(Object entity) {
            if (entity instanceof Agency) {
                Agency agency = (Agency)entity;
                if (agency.getId() == null) {
                    if (GtfsReader.this._defaultAgencyId == null) {
                        agency.setId(agency.getName());
                    } else {
                        agency.setId(GtfsReader.this._defaultAgencyId);
                    }
                }
                if (GtfsReader.this._agencies.contains(agency)) {
                    return;
                }
                GtfsReader.this._agencies.add((Agency)entity);
            } else if (entity instanceof BookingRule) {
                BookingRule bookingRule = (BookingRule)entity;
                this.registerAgencyId(BookingRule.class, bookingRule.getId());
            } else if (entity instanceof Pathway) {
                Pathway pathway = (Pathway)entity;
                this.registerAgencyId(Pathway.class, pathway.getId());
            } else if (entity instanceof Level) {
                Level level = (Level)entity;
                this.registerAgencyId(Level.class, level.getId());
            } else if (entity instanceof Route) {
                Route route = (Route)entity;
                this.registerAgencyId(Route.class, route.getId());
            } else if (entity instanceof Trip) {
                Trip trip = (Trip)entity;
                this.registerAgencyId(Trip.class, trip.getId());
            } else if (entity instanceof Stop) {
                Stop stop = (Stop)entity;
                this.registerAgencyId(Stop.class, stop.getId());
            } else if (entity instanceof FareProduct) {
                FareProduct product = (FareProduct)entity;
                this.registerAgencyId(FareProduct.class, product.getId());
            } else if (entity instanceof FareMedium) {
                FareMedium medium = (FareMedium)entity;
                this.registerAgencyId(FareMedium.class, medium.getId());
            } else if (entity instanceof RiderCategory) {
                RiderCategory category = (RiderCategory)entity;
                this.registerAgencyId(RiderCategory.class, category.getId());
            } else if (entity instanceof FareAttribute) {
                FareAttribute fare = (FareAttribute)entity;
                this.registerAgencyId(FareAttribute.class, fare.getId());
            } else if (entity instanceof Note) {
                Note note = (Note)entity;
                this.registerAgencyId(Note.class, note.getId());
            } else if (entity instanceof Area) {
                Area area = (Area)entity;
                this.registerAgencyId(Area.class, area.getId());
            } else if (entity instanceof Location) {
                Location location = (Location)entity;
                this.registerAgencyId(Location.class, location.getId());
            } else if (entity instanceof LocationGroup) {
                LocationGroup group = (LocationGroup)entity;
                this.registerAgencyId(LocationGroup.class, group.getId());
            } else if (entity instanceof LocationGroupElement) {
                LocationGroupElement locationGroupElement = (LocationGroupElement)entity;
                LocationGroup locationGroup = GtfsReader.this._entityStore.getEntityForId(LocationGroup.class, locationGroupElement.getLocationGroupId());
                locationGroup.addLocation(locationGroupElement.getStop());
            } else if (entity instanceof StopAreaElement) {
                StopAreaElement stopAreaElement = (StopAreaElement)entity;
                StopArea stopArea = GtfsReader.this._entityStore.getEntityForId(StopArea.class, stopAreaElement.getArea().getId());
                if (stopArea == null) {
                    stopArea = new StopArea();
                    stopArea.setArea(stopAreaElement.getArea());
                    GtfsReader.this._entityStore.saveEntity(stopArea);
                }
                stopArea.addLocation(stopAreaElement.getStopLocation());
            } else if (entity instanceof Vehicle) {
                Vehicle vehicle = (Vehicle)entity;
                this.registerAgencyId(Vehicle.class, vehicle.getId());
            } else if (entity instanceof Facility) {
                Facility facility = (Facility)entity;
                this.registerAgencyId(Facility.class, facility.getId());
            } else if (entity instanceof FacilityPropertyDefinition) {
                FacilityPropertyDefinition facilityPropertyDefinition = (FacilityPropertyDefinition)entity;
                this.registerAgencyId(FacilityPropertyDefinition.class, facilityPropertyDefinition.getId());
            }
            if (entity instanceof IdentityBean) {
                GtfsReader.this._entityStore.saveEntity(entity);
            }
        }

        private void registerAgencyId(Class<?> entityType, AgencyAndId id) {
            Map<String, String> agencyIdsByEntityId = GtfsReader.this._agencyIdsByEntityClassAndId.get(entityType);
            if (agencyIdsByEntityId == null) {
                agencyIdsByEntityId = new HashMap<String, String>();
                GtfsReader.this._agencyIdsByEntityClassAndId.put(entityType, agencyIdsByEntityId);
            }
            if (agencyIdsByEntityId.containsKey(id.getId()) && !GtfsReader.this._overwriteDuplicates) {
                throw new DuplicateEntityException(entityType, id);
            }
            agencyIdsByEntityId.put(id.getId(), id.getAgencyId());
        }
    }
}

