/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry.primitive;

import java.util.List;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPositionImpl;
import org.geotools.geometry.jts.spatialschema.geometry.geometry.GeometryFactoryImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.CurveImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.PointImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.PolyhedralSurfaceImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.RingImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.SurfaceBoundaryImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.SurfaceImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Solid;
import org.opengis.geometry.primitive.SolidBoundary;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.geometry.primitive.SurfacePatch;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PrimitiveFactoryImpl
implements PrimitiveFactory {
    private CoordinateReferenceSystem crs;
    private GeometryFactory geomFact;

    public PrimitiveFactoryImpl() {
        this(null);
    }

    public PrimitiveFactoryImpl(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.geomFact = new GeometryFactoryImpl(crs);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Primitive createPrimitive(Envelope envelope) {
        return null;
    }

    public DirectPosition createDirectPosition(double[] coordinates) {
        if (coordinates != null) {
            return new DirectPositionImpl(this.crs, coordinates);
        }
        return new DirectPositionImpl(this.crs);
    }

    public Point createPoint(double[] coordinates) {
        return new PointImpl(this.createDirectPosition(coordinates), this.crs);
    }

    public Point createPoint(Position position) {
        return new PointImpl(position.getDirectPosition(), this.crs);
    }

    public Curve createCurve(List<CurveSegment> segments) {
        CurveImpl result = new CurveImpl(this.crs);
        if (segments != null) {
            result.getSegments().addAll(segments);
        }
        return result;
    }

    public Surface createSurface(List<SurfacePatch> patches) {
        SurfaceImpl result = new SurfaceImpl(this.crs);
        List<SurfacePatch> cast = patches;
        result.getPatches().addAll(cast);
        return result;
    }

    public Surface createSurface(SurfaceBoundary boundary) {
        SurfaceImpl result = new SurfaceImpl(this.crs);
        Polygon poly = this.geomFact.createPolygon(boundary);
        result.getPatches().add(poly);
        return result;
    }

    public SurfaceBoundary createSurfaceBoundary(Ring exterior, List interiors) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return new SurfaceBoundaryImpl(this.crs, exterior, interiors.toArray(new Ring[interiors.size()]));
    }

    public Solid createSolid(SolidBoundary boundary) {
        return null;
    }

    public Ring createRing(List curves) {
        RingImpl result = new RingImpl(this.crs);
        if (curves != null) {
            result.getGenerators().addAll(curves);
        }
        return result;
    }

    public PolyhedralSurface createPolyhedralSurface(List<Polygon> patches) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        PolyhedralSurfaceImpl result = new PolyhedralSurfaceImpl(this.crs);
        List<Polygon> cast = patches;
        result.getPatches().addAll(cast);
        return result;
    }
}

