/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.factory.BasicFactories;
import org.geotools.geometry.jts.JTSGeometry;
import org.geotools.geometry.jts.JTSUtils;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPositionImpl;
import org.geotools.geometry.jts.spatialschema.geometry.EnvelopeImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.CurveBoundaryImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.PointImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.SurfaceBoundaryImpl;
import org.opengis.geometry.Boundary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.Precision;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.Cloneable;

public abstract class GeometryImpl
implements Geometry,
Serializable,
Cloneable,
JTSGeometry {
    private boolean mutable;
    private CoordinateReferenceSystem coordinateReferenceSystem;
    private com.vividsolutions.jts.geom.Geometry jtsPeer;
    private JTSGeometry parent;
    private Precision precision;

    public GeometryImpl() {
        this(null);
    }

    public GeometryImpl(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(coordinateReferenceSystem, true);
    }

    public GeometryImpl(CoordinateReferenceSystem coordinateReferenceSystem, boolean mutable) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
        this.mutable = mutable;
    }

    public void setParent(JTSGeometry parent) {
        this.parent = parent;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    protected abstract com.vividsolutions.jts.geom.Geometry computeJTSPeer();

    @Override
    public final void invalidateCachedJTSPeer() {
        this.jtsPeer = null;
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
    }

    protected final void setJTSPeer(com.vividsolutions.jts.geom.Geometry g) {
        this.jtsPeer = g;
    }

    @Override
    public final com.vividsolutions.jts.geom.Geometry getJTSGeometry() {
        if (this.jtsPeer == null) {
            this.jtsPeer = this.computeJTSPeer();
        }
        return this.jtsPeer;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public final Geometry getMbRegion() {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        return JTSUtils.jtsToGo1(jtsGeom.getEnvelope(), this.getCoordinateReferenceSystem());
    }

    public final DirectPosition getRepresentativePoint() {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        Point p = jtsGeom.getInteriorPoint();
        return JTSUtils.pointToDirectPosition(p, this.getCoordinateReferenceSystem());
    }

    public Boundary getBoundary() {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        if (jtsGeom instanceof GeometryCollection) {
            throw new UnsupportedOperationException("Boundary cannot be computed for multi-primitives.");
        }
        com.vividsolutions.jts.geom.Geometry jtsBoundary = jtsGeom.getBoundary();
        int d = jtsGeom.getDimension();
        if (d == 0) {
            return null;
        }
        if (d == 1) {
            Coordinate[] coords = jtsBoundary.getCoordinates();
            if (coords == null || coords.length == 0) {
                CurveBoundaryImpl result = new CurveBoundaryImpl(this.getCoordinateReferenceSystem(), null, null);
                return result;
            }
            if (coords.length != 2) {
                throw new RuntimeException("ERROR: One dimensional primitive had wrong number of boundary points (" + coords.length + ")");
            }
            CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
            CurveBoundaryImpl result = new CurveBoundaryImpl(crs, new PointImpl(JTSUtils.coordinateToDirectPosition(coords[0], crs)), new PointImpl(JTSUtils.coordinateToDirectPosition(coords[1], crs)));
            return result;
        }
        if (d == 2) {
            MultiLineString mls = (MultiLineString)jtsBoundary;
            int n = mls.getNumGeometries();
            CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
            Ring exteriorRing = JTSUtils.linearRingToRing((LineString)mls.getGeometryN(0), crs);
            Ring[] interiorRings = new Ring[n - 1];
            for (int i = 1; i < n; ++i) {
                interiorRings[n - 1] = JTSUtils.linearRingToRing((LineString)mls.getGeometryN(i), crs);
            }
            SurfaceBoundaryImpl result = new SurfaceBoundaryImpl(crs, exteriorRing, interiorRings);
            return result;
        }
        throw new UnsupportedOperationException("Computing the boundary for geometries of dimension larger than 2 is not supported.");
    }

    public final Complex getClosure() {
        throw new UnsupportedOperationException("Closure not supported");
    }

    public final boolean isSimple() {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        return jtsGeom.isSimple();
    }

    public final boolean isCycle() {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsBoundary = jtsGeom.getBoundary();
        return jtsBoundary.isEmpty();
    }

    public final double getDistance(Geometry geometry) {
        com.vividsolutions.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)geometry).getJTSGeometry();
        return JTSUtils.distance(jtsGeom1, jtsGeom2);
    }

    public final int getDimension(DirectPosition point) {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        if (jtsGeom instanceof GeometryCollection) {
            Point p = JTSUtils.directPositionToPoint(point);
            return GeometryImpl.getDimension(p, (GeometryCollection)jtsGeom);
        }
        return jtsGeom.getDimension();
    }

    private static final int getDimension(Point p, GeometryCollection gc) {
        int min = Integer.MAX_VALUE;
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            int d = Integer.MAX_VALUE;
            com.vividsolutions.jts.geom.Geometry g = gc.getGeometryN(i);
            if (g instanceof GeometryCollection) {
                d = GeometryImpl.getDimension(p, (GeometryCollection)g);
            } else if (g.intersects((com.vividsolutions.jts.geom.Geometry)p)) {
                d = g.getDimension();
            }
            if (d >= min) continue;
            min = d;
        }
        return min;
    }

    public final int getCoordinateDimension() {
        return this.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
    }

    public final Set getMaximalComplex() {
        return null;
    }

    public final Geometry transform(CoordinateReferenceSystem newCRS) throws TransformException {
        try {
            BasicFactories commonFactory = BasicFactories.getDefault();
            CoordinateOperationFactory cof = commonFactory.getCoordinateOperationFactory();
            CoordinateReferenceSystem oldCRS = this.getCoordinateReferenceSystem();
            CoordinateOperation coordOp = cof.createOperation(oldCRS, newCRS);
            MathTransform mt = coordOp.getMathTransform();
            return this.transform(newCRS, mt);
        }
        catch (OperationNotFoundException e) {
            throw new TransformException("Unable to find an operation", (Throwable)e);
        }
        catch (FactoryException e) {
            throw new TransformException("Factory exception", (Throwable)e);
        }
    }

    public final Geometry transform(CoordinateReferenceSystem newCRS, MathTransform transform) throws TransformException {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        jtsGeom = (com.vividsolutions.jts.geom.Geometry)jtsGeom.clone();
        CoordinateReferenceSystem oldCRS = this.getCoordinateReferenceSystem();
        jtsGeom.apply((CoordinateFilter)new MathTransformFilter(transform, oldCRS, newCRS));
        return JTSUtils.jtsToGo1(jtsGeom, this.getCoordinateReferenceSystem());
    }

    public final org.opengis.geometry.Envelope getEnvelope() {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        Envelope jtsEnv = jtsGeom.getEnvelopeInternal();
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        EnvelopeImpl result = new EnvelopeImpl(new DirectPositionImpl(crs, new double[]{jtsEnv.getMinX(), jtsEnv.getMinY()}), new DirectPositionImpl(crs, new double[]{jtsEnv.getMaxX(), jtsEnv.getMaxY()}));
        return result;
    }

    public final DirectPosition getCentroid() {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        Point jtsCentroid = jtsGeom.getCentroid();
        return JTSUtils.pointToDirectPosition(jtsCentroid, this.getCoordinateReferenceSystem());
    }

    public final Geometry getConvexHull() {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsHull = jtsGeom.convexHull();
        return JTSUtils.jtsToGo1(jtsHull, this.getCoordinateReferenceSystem());
    }

    public final Geometry getBuffer(double distance) {
        com.vividsolutions.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsBuffer = jtsGeom.buffer(distance);
        return JTSUtils.jtsToGo1(jtsBuffer, this.getCoordinateReferenceSystem());
    }

    public final boolean isMutable() {
        return this.mutable;
    }

    public final Geometry toImmutable() {
        if (this.isMutable()) {
            GeometryImpl result = this.clone();
            result.mutable = false;
            return result;
        }
        return this;
    }

    public GeometryImpl clone() {
        try {
            return (GeometryImpl)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError((Object)cnse);
        }
    }

    public boolean contains(DirectPosition point) {
        com.vividsolutions.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        Point jtsGeom2 = JTSUtils.directPositionToPoint(point);
        return JTSUtils.contains(jtsGeom1, (com.vividsolutions.jts.geom.Geometry)jtsGeom2);
    }

    public boolean contains(TransfiniteSet pointSet) {
        com.vividsolutions.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.contains(jtsGeom1, jtsGeom2);
    }

    public double distance(Geometry otherGeometry) {
        return this.getDistance(otherGeometry);
    }

    public TransfiniteSet difference(TransfiniteSet pointSet) {
        com.vividsolutions.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.jtsToGo1(JTSUtils.difference(jtsGeom1, jtsGeom2), this.getCoordinateReferenceSystem());
    }

    public boolean equals(TransfiniteSet pointSet) {
        com.vividsolutions.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.equals(jtsGeom1, jtsGeom2);
    }

    public TransfiniteSet intersection(TransfiniteSet pointSet) {
        com.vividsolutions.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.jtsToGo1(JTSUtils.intersection(jtsGeom1, jtsGeom2), this.getCoordinateReferenceSystem());
    }

    public boolean intersects(TransfiniteSet pointSet) {
        com.vividsolutions.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.intersects(jtsGeom1, jtsGeom2);
    }

    public TransfiniteSet symmetricDifference(TransfiniteSet pointSet) {
        com.vividsolutions.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.jtsToGo1(JTSUtils.symmetricDifference(jtsGeom1, jtsGeom2), this.getCoordinateReferenceSystem());
    }

    public TransfiniteSet union(TransfiniteSet pointSet) {
        com.vividsolutions.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        com.vividsolutions.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.jtsToGo1(JTSUtils.union(jtsGeom1, jtsGeom2), this.getCoordinateReferenceSystem());
    }

    public static Set listAsSet(final List list) {
        return new Set(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public void clear() {
                list.clear();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }

            @Override
            public Object[] toArray() {
                return list.toArray();
            }

            @Override
            public boolean add(Object o) {
                return list.add(o);
            }

            @Override
            public boolean contains(Object o) {
                return list.contains(o);
            }

            @Override
            public boolean remove(Object o) {
                return list.remove(o);
            }

            @Override
            public boolean addAll(Collection c) {
                return list.addAll(c);
            }

            @Override
            public boolean containsAll(Collection c) {
                return list.containsAll(c);
            }

            @Override
            public boolean removeAll(Collection c) {
                return list.removeAll(c);
            }

            @Override
            public boolean retainAll(Collection c) {
                return list.retainAll(c);
            }

            @Override
            public Iterator iterator() {
                return list.iterator();
            }

            @Override
            public Object[] toArray(Object[] a) {
                return list.toArray(a);
            }
        };
    }

    public static class MathTransformFilter
    implements CoordinateFilter {
        private MathTransform transform;
        private DirectPosition src;
        private DirectPosition dst;

        public MathTransformFilter(MathTransform transform, CoordinateReferenceSystem oldCRS, CoordinateReferenceSystem newCRS) {
            this.transform = transform;
            this.src = new DirectPositionImpl(oldCRS);
            this.dst = new DirectPositionImpl(newCRS);
        }

        public void filter(Coordinate coord) {
            JTSUtils.coordinateToDirectPosition(coord, this.src);
            try {
                this.transform.transform(this.src, this.dst);
            }
            catch (MismatchedDimensionException e) {
                throw new RuntimeException(e);
            }
            catch (TransformException e) {
                throw new RuntimeException(e);
            }
            JTSUtils.directPositionToCoordinate(this.dst, coord);
        }
    }
}

