/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import java.util.Date;
import java.util.List;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertsPersistence;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ServiceAlertsPersistenceDB
implements ServiceAlertsPersistence {
    private static final long DEFAULT_REFRESH_INTERVAL = 60000L;
    private static Logger _log = LoggerFactory.getLogger(ServiceAlertsPersistenceDB.class);
    private SessionFactory _sessionFactory;
    private long lastModified = 0L;
    private long lastRefresh = 0L;
    private long rowCount = 0L;
    protected long _refreshInterval = 60000L;

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    private Session getSession() {
        return this._sessionFactory.getCurrentSession();
    }

    public void setRefreshInterval(int refreshInterval) {
        this._refreshInterval = refreshInterval;
    }

    @Override
    @Transactional
    public void delete(ServiceAlertRecord existingServiceAlertRecord) {
        _log.debug("deleting " + (existingServiceAlertRecord == null ? "NuLl" : existingServiceAlertRecord.getServiceAlertId()));
        this.getSession().delete((Object)existingServiceAlertRecord);
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public synchronized boolean cachedNeedsSync() {
        long now = SystemTime.currentTimeMillis();
        if (now > this.lastRefresh + this._refreshInterval) {
            this.lastRefresh = now;
            return this.needsSync();
        }
        return false;
    }

    @Override
    @Transactional
    public boolean deleteOrphans() {
        try {
            NativeQuery sqlQuery = this.getSession().createSQLQuery("delete from transit_data_service_alerts_localized_strings where servicealert_url_id is null AND servicealert_summary_id is null AND servicealert_description_id is null");
            sqlQuery.executeUpdate();
            sqlQuery = this.getSession().createSQLQuery("delete from transit_data_service_alerts_situation_affects where serviceAlertRecord_Id is null");
            sqlQuery.executeUpdate();
            sqlQuery = this.getSession().createSQLQuery("delete from transit_data_service_alerts_situation_consequence where serviceAlertRecord_Id is null");
            sqlQuery.executeUpdate();
            sqlQuery = this.getSession().createSQLQuery("delete from transit_data_service_alerts_time_ranges where serviceAlertRecord_id is null AND servicealert_publication_window_id is null AND servicealert_active_window_id is null");
            sqlQuery.executeUpdate();
        }
        catch (Exception any) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public synchronized boolean needsSync() {
        Long dbLastModified = this.getLastModified();
        if (dbLastModified == null) {
            _log.debug("no dbLastModified with this.lastModified=" + new Date(this.lastModified));
        }
        if (dbLastModified == null) {
            dbLastModified = this.lastRefresh;
        }
        if (dbLastModified > this.lastModified) {
            _log.debug("in needsSync with delta dbLast - lastmod = " + (dbLastModified - this.lastModified) + ", " + new Date(dbLastModified) + ", " + new Date(this.lastModified) + ", " + dbLastModified + ", " + this.lastModified);
            this.lastModified = dbLastModified;
            return true;
        }
        long rowCount = this.getRowCount();
        if (rowCount != this.rowCount) {
            _log.info("rowCount changed from " + this.rowCount + " to " + rowCount);
            this.rowCount = rowCount;
            return true;
        }
        return false;
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    long getRowCount() {
        try {
            Query query = this.getSession().createQuery("SELECT count(serviceAlert) FROM ServiceAlertRecord serviceAlert");
            return (Long)query.list().get(0);
        }
        catch (Throwable t) {
            _log.error("hibernate blew:", t);
            return -1L;
        }
    }

    @Override
    @Transactional
    public List<ServiceAlertRecord> getAlerts() {
        Query query = this.getSession().createQuery("SELECT serviceAlert FROM ServiceAlertRecord serviceAlert left join fetch serviceAlert.consequences cs left join fetch cs.detourStopIds dsi ");
        return query.list();
    }

    @Override
    @Transactional
    public void saveOrUpdate(ServiceAlertRecord record) {
        this.getSession().saveOrUpdate((Object)record);
    }

    @Override
    @Transactional
    public void saveOrUpdate(List<ServiceAlertRecord> records) {
        for (ServiceAlertRecord record : records) {
            this.getSession().saveOrUpdate((Object)record);
        }
    }

    @Override
    @Transactional
    public ServiceAlertRecord getServiceAlertRecordByAlertId(String agencyId, String serviceAlertId) {
        Query query = this.getSession().createQuery("SELECT serviceAlert FROM ServiceAlertRecord serviceAlert WHERE serviceAlertId = :serviceAlertId and agencyId = :agencyId");
        query.setString("serviceAlertId", serviceAlertId);
        query.setString("agencyId", agencyId);
        try {
            return (ServiceAlertRecord)query.uniqueResult();
        }
        catch (NonUniqueResultException nure) {
            List list = query.list();
            _log.error("expected single result for {}:{}, got {}", new Object[]{agencyId, serviceAlertId, list});
            System.out.println("getServiceAlertRecordByAlertId expected single result for " + agencyId + ":" + serviceAlertId);
            return (ServiceAlertRecord)query.list().get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getLastModified() {
        long start = SystemTime.currentTimeMillis();
        try {
            Query query = this.getSession().createQuery("SELECT max(serviceAlert.modifiedTime) FROM ServiceAlertRecord serviceAlert");
            Long l = (Long)query.list().get(0);
            return l;
        }
        catch (Throwable t) {
            _log.error("hibernate blew:", t);
            Long l = null;
            return l;
        }
        finally {
            long stop = SystemTime.currentTimeMillis();
            _log.debug("getLastModified took " + (stop - start) + "ms");
        }
    }
}

