/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.onebusaway.alerts.impl.RouteAndDirectionRef;
import org.onebusaway.alerts.impl.RouteAndStopCallRef;
import org.onebusaway.alerts.impl.RouteDirectionAndStopCallRef;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertsCache;
import org.onebusaway.alerts.impl.TripAndStopCallRef;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.springframework.stereotype.Component;

@Component
public class ServiceAlertsCacheInMemoryImpl
implements ServiceAlertsCache {
    private final Semaphore _available = new Semaphore(1, true);
    private ConcurrentMap<AgencyAndId, ServiceAlertRecord> _serviceAlerts = new ConcurrentHashMap<AgencyAndId, ServiceAlertRecord>();
    private ConcurrentMap<String, Set<AgencyAndId>> _serviceAlertIdsByServiceAlertAgencyId = new ConcurrentHashMap<String, Set<AgencyAndId>>();
    private ConcurrentMap<String, Set<AgencyAndId>> _serviceAlertIdsByAgencyId = new ConcurrentHashMap<String, Set<AgencyAndId>>();
    private ConcurrentMap<AgencyAndId, Set<AgencyAndId>> _serviceAlertIdsByStopId = new ConcurrentHashMap<AgencyAndId, Set<AgencyAndId>>();
    private ConcurrentMap<AgencyAndId, Set<AgencyAndId>> _serviceAlertIdsByRouteId = new ConcurrentHashMap<AgencyAndId, Set<AgencyAndId>>();
    private ConcurrentMap<RouteAndDirectionRef, Set<AgencyAndId>> _serviceAlertIdsByRouteAndDirectionId = new ConcurrentHashMap<RouteAndDirectionRef, Set<AgencyAndId>>();
    private ConcurrentMap<RouteAndStopCallRef, Set<AgencyAndId>> _serviceAlertIdsByRouteAndStop = new ConcurrentHashMap<RouteAndStopCallRef, Set<AgencyAndId>>();
    private ConcurrentMap<RouteDirectionAndStopCallRef, Set<AgencyAndId>> _serviceAlertIdsByRouteDirectionAndStopCall = new ConcurrentHashMap<RouteDirectionAndStopCallRef, Set<AgencyAndId>>();
    private ConcurrentMap<AgencyAndId, Set<AgencyAndId>> _serviceAlertIdsByTripId = new ConcurrentHashMap<AgencyAndId, Set<AgencyAndId>>();
    private ConcurrentMap<TripAndStopCallRef, Set<AgencyAndId>> _serviceAlertIdsByTripAndStopId = new ConcurrentHashMap<TripAndStopCallRef, Set<AgencyAndId>>();

    @Override
    public void clear() {
        try {
            this._available.acquire();
            this._serviceAlerts.clear();
            this._serviceAlertIdsByServiceAlertAgencyId.clear();
            this._serviceAlertIdsByAgencyId.clear();
            this._serviceAlertIdsByStopId.clear();
            this._serviceAlertIdsByRouteId.clear();
            this._serviceAlertIdsByRouteAndDirectionId.clear();
            this._serviceAlertIdsByRouteAndStop.clear();
            this._serviceAlertIdsByRouteDirectionAndStopCall.clear();
            this._serviceAlertIdsByTripId.clear();
            this._serviceAlertIdsByTripAndStopId.clear();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
    }

    @Override
    public Map<AgencyAndId, ServiceAlertRecord> getServiceAlerts() {
        try {
            this._available.acquire();
            ConcurrentMap<AgencyAndId, ServiceAlertRecord> concurrentMap = this._serviceAlerts;
            return concurrentMap;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public ServiceAlertRecord removeServiceAlert(AgencyAndId serviceAlertId) {
        try {
            this._available.acquire();
            ServiceAlertRecord serviceAlertRecord = (ServiceAlertRecord)this._serviceAlerts.remove(serviceAlertId);
            return serviceAlertRecord;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceAlertRecord putServiceAlert(AgencyAndId id, ServiceAlertRecord serviceAlert) {
        try {
            this._available.acquire();
            ServiceAlertRecord existing = (ServiceAlertRecord)this._serviceAlerts.get(id);
            this._serviceAlerts.put(id, serviceAlert);
            ServiceAlertRecord serviceAlertRecord = existing;
            return serviceAlertRecord;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public Map<String, Set<AgencyAndId>> getServiceAlertIdsByServiceAlertAgencyId() {
        try {
            this._available.acquire();
            ConcurrentMap<String, Set<AgencyAndId>> concurrentMap = this._serviceAlertIdsByServiceAlertAgencyId;
            return concurrentMap;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public Map<String, Set<AgencyAndId>> getServiceAlertIdsByAgencyId() {
        try {
            this._available.acquire();
            ConcurrentMap<String, Set<AgencyAndId>> concurrentMap = this._serviceAlertIdsByAgencyId;
            return concurrentMap;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public Map<AgencyAndId, Set<AgencyAndId>> getServiceAlertIdsByStopId() {
        try {
            this._available.acquire();
            ConcurrentMap<AgencyAndId, Set<AgencyAndId>> concurrentMap = this._serviceAlertIdsByStopId;
            return concurrentMap;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public Map<AgencyAndId, Set<AgencyAndId>> getServiceAlertIdsByRouteId() {
        try {
            this._available.acquire();
            ConcurrentMap<AgencyAndId, Set<AgencyAndId>> concurrentMap = this._serviceAlertIdsByRouteId;
            return concurrentMap;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public Map<RouteAndDirectionRef, Set<AgencyAndId>> getServiceAlertIdsByRouteAndDirectionId() {
        try {
            this._available.acquire();
            ConcurrentMap<RouteAndDirectionRef, Set<AgencyAndId>> concurrentMap = this._serviceAlertIdsByRouteAndDirectionId;
            return concurrentMap;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public Map<RouteAndStopCallRef, Set<AgencyAndId>> getServiceAlertIdsByRouteAndStop() {
        try {
            this._available.acquire();
            ConcurrentMap<RouteAndStopCallRef, Set<AgencyAndId>> concurrentMap = this._serviceAlertIdsByRouteAndStop;
            return concurrentMap;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public Map<RouteDirectionAndStopCallRef, Set<AgencyAndId>> getServiceAlertIdsByRouteDirectionAndStopCall() {
        try {
            this._available.acquire();
            ConcurrentMap<RouteDirectionAndStopCallRef, Set<AgencyAndId>> concurrentMap = this._serviceAlertIdsByRouteDirectionAndStopCall;
            return concurrentMap;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public Map<AgencyAndId, Set<AgencyAndId>> getServiceAlertIdsByTripId() {
        try {
            this._available.acquire();
            ConcurrentMap<AgencyAndId, Set<AgencyAndId>> concurrentMap = this._serviceAlertIdsByTripId;
            return concurrentMap;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }

    @Override
    public Map<TripAndStopCallRef, Set<AgencyAndId>> getServiceAlertIdsByTripAndStopId() {
        try {
            this._available.acquire();
            ConcurrentMap<TripAndStopCallRef, Set<AgencyAndId>> concurrentMap = this._serviceAlertIdsByTripAndStopId;
            return concurrentMap;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._available.release();
        }
        return null;
    }
}

