/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import org.onebusaway.alerts.service.ServiceAlerts;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.service_alerts.EEffect;
import org.onebusaway.transit_data.model.service_alerts.ESeverity;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceAlertLibrary {
    private static final Logger _log = LoggerFactory.getLogger(ServiceAlertLibrary.class);

    public static final AgencyAndId agencyAndId(String agencyId, String id) {
        return new AgencyAndId(agencyId, id);
    }

    public static final AgencyAndId agencyAndIdAndId(String agencyId, String id) {
        if (id != null && id.indexOf(95) != -1) {
            return AgencyAndIdLibrary.convertFromString((String)id);
        }
        return new AgencyAndId(agencyId, id);
    }

    public static ServiceAlerts.Id id(AgencyAndId id) {
        return ServiceAlertLibrary.id(id.getAgencyId(), id.getId());
    }

    public static ServiceAlerts.Id id(String agencyId, String id) {
        ServiceAlerts.Id.Builder builder = ServiceAlerts.Id.newBuilder();
        builder.setAgencyId(agencyId);
        builder.setId(id);
        return builder.build();
    }

    public static ServiceAlerts.ServiceAlert.Severity convertSeverity(ESeverity severity) {
        switch (severity) {
            case NO_IMPACT: {
                return ServiceAlerts.ServiceAlert.Severity.NO_IMPACT;
            }
            case UNKNOWN: {
                return ServiceAlerts.ServiceAlert.Severity.UNKNOWN;
            }
            case VERY_SLIGHT: {
                return ServiceAlerts.ServiceAlert.Severity.VERY_SLIGHT;
            }
            case SLIGHT: {
                return ServiceAlerts.ServiceAlert.Severity.SLIGHT;
            }
            case NORMAL: {
                return ServiceAlerts.ServiceAlert.Severity.NORMAL;
            }
            case SEVERE: {
                return ServiceAlerts.ServiceAlert.Severity.SEVERE;
            }
            case VERY_SEVERE: {
                return ServiceAlerts.ServiceAlert.Severity.VERY_SEVERE;
            }
        }
        _log.warn("unkown severity level: " + severity);
        return ServiceAlerts.ServiceAlert.Severity.UNKNOWN;
    }

    public static ESeverity convertSeverity(ServiceAlerts.ServiceAlert.Severity severity) {
        switch (severity) {
            case NO_IMPACT: {
                return ESeverity.NO_IMPACT;
            }
            case UNKNOWN: {
                return ESeverity.UNKNOWN;
            }
            case VERY_SLIGHT: {
                return ESeverity.VERY_SLIGHT;
            }
            case SLIGHT: {
                return ESeverity.SLIGHT;
            }
            case NORMAL: {
                return ESeverity.NORMAL;
            }
            case SEVERE: {
                return ESeverity.SEVERE;
            }
            case VERY_SEVERE: {
                return ESeverity.VERY_SEVERE;
            }
        }
        _log.warn("unkown severity level: " + severity);
        return ESeverity.UNKNOWN;
    }

    public static EEffect convertEffect(ServiceAlerts.Consequence.Effect effect) {
        switch (effect) {
            case NO_SERVICE: {
                return EEffect.NO_SERVICE;
            }
            case REDUCED_SERVICE: {
                return EEffect.REDUCED_SERVICE;
            }
            case SIGNIFICANT_DELAYS: {
                return EEffect.SIGNIFICANT_DELAYS;
            }
            case DETOUR: {
                return EEffect.DETOUR;
            }
            case ADDITIONAL_SERVICE: {
                return EEffect.ADDITIONAL_SERVICE;
            }
            case MODIFIED_SERVICE: {
                return EEffect.MODIFIED_SERVICE;
            }
            case OTHER_EFFECT: {
                return EEffect.OTHER_EFFECT;
            }
            case UNKNOWN_EFFECT: {
                return EEffect.UNKNOWN_EFFECT;
            }
            case STOP_MOVED: {
                return EEffect.STOP_MOVED;
            }
        }
        _log.warn("unknown Consequence.Effect " + effect);
        return EEffect.UNKNOWN_EFFECT;
    }

    public static ServiceAlerts.Consequence.Effect convertEffect(EEffect effect) {
        switch (effect) {
            case NO_SERVICE: {
                return ServiceAlerts.Consequence.Effect.NO_SERVICE;
            }
            case REDUCED_SERVICE: {
                return ServiceAlerts.Consequence.Effect.REDUCED_SERVICE;
            }
            case SIGNIFICANT_DELAYS: {
                return ServiceAlerts.Consequence.Effect.SIGNIFICANT_DELAYS;
            }
            case DETOUR: {
                return ServiceAlerts.Consequence.Effect.DETOUR;
            }
            case ADDITIONAL_SERVICE: {
                return ServiceAlerts.Consequence.Effect.ADDITIONAL_SERVICE;
            }
            case MODIFIED_SERVICE: {
                return ServiceAlerts.Consequence.Effect.MODIFIED_SERVICE;
            }
            case OTHER_EFFECT: {
                return ServiceAlerts.Consequence.Effect.OTHER_EFFECT;
            }
            case UNKNOWN_EFFECT: {
                return ServiceAlerts.Consequence.Effect.UNKNOWN_EFFECT;
            }
            case STOP_MOVED: {
                return ServiceAlerts.Consequence.Effect.STOP_MOVED;
            }
        }
        _log.warn("unknown effect " + effect);
        return ServiceAlerts.Consequence.Effect.UNKNOWN_EFFECT;
    }
}

