/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.alerts.impl.ServiceAlertLibrary;
import org.onebusaway.alerts.impl.ServiceAlertLocalizedString;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertSituationConsequenceClause;
import org.onebusaway.alerts.impl.ServiceAlertTimeRange;
import org.onebusaway.alerts.impl.ServiceAlertsSituationAffectsClause;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.service_alerts.ECause;
import org.onebusaway.transit_data.model.service_alerts.NaturalLanguageStringBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertRecordBean;
import org.onebusaway.transit_data.model.service_alerts.SituationAffectsBean;
import org.onebusaway.transit_data.model.service_alerts.SituationConsequenceBean;
import org.onebusaway.transit_data.model.service_alerts.TimeRangeBean;
import org.onebusaway.util.AgencyAndIdLibrary;

public class ServiceAlertBeanHelper {
    public static List<ServiceAlertBean> list(List<ServiceAlertRecord> serviceAlerts) {
        ArrayList<ServiceAlertBean> beans = new ArrayList<ServiceAlertBean>();
        for (ServiceAlertRecord serviceAlert : serviceAlerts) {
            beans.add(ServiceAlertBeanHelper.getServiceAlertAsBean(serviceAlert));
        }
        return beans;
    }

    public static ServiceAlertBean getServiceAlertAsBean(ServiceAlertRecord serviceAlert) {
        ServiceAlertBean bean = new ServiceAlertBean();
        if (serviceAlert == null) {
            return bean;
        }
        AgencyAndId id = ServiceAlertLibrary.agencyAndId(serviceAlert.getAgencyId(), serviceAlert.getServiceAlertId());
        bean.setId(AgencyAndIdLibrary.convertToString((AgencyAndId)id));
        bean.setCreationTime(serviceAlert.getCreationTime());
        bean.setActiveWindows(ServiceAlertBeanHelper.getRangesAsBeans(serviceAlert.getActiveWindows()));
        bean.setPublicationWindows(ServiceAlertBeanHelper.getRangesAsBeans(serviceAlert.getPublicationWindows()));
        if (serviceAlert.getCause() != null) {
            bean.setReason(ServiceAlertBeanHelper.getCauseAsReason(serviceAlert.getCause()));
        }
        bean.setSummaries(ServiceAlertBeanHelper.getTranslatedStringsAsNLSBeans(serviceAlert.getSummaries()));
        bean.setDescriptions(ServiceAlertBeanHelper.getTranslatedStringsAsNLSBeans(serviceAlert.getDescriptions()));
        bean.setUrls(ServiceAlertBeanHelper.getTranslatedStringsAsNLSBeans(serviceAlert.getUrls()));
        if (serviceAlert.getSeverity() != null) {
            bean.setSeverity(serviceAlert.getSeverity());
        }
        bean.setAllAffects(ServiceAlertBeanHelper.getAffectsAsBeans(serviceAlert));
        bean.setConsequences(ServiceAlertBeanHelper.getConsequencesAsBeans(serviceAlert));
        bean.setSource(serviceAlert.getSource());
        bean.setConsequenceMessage(serviceAlert.getConsequenceMessage());
        return bean;
    }

    public static ServiceAlertRecord getServiceAlertRecordFromServiceAlertBean(ServiceAlertBean bean, String agencyId) {
        ServiceAlertLocalizedString string;
        ServiceAlertRecord serviceAlertRecord = new ServiceAlertRecord();
        serviceAlertRecord.setAgencyId(agencyId);
        if (bean.getId() != null && !bean.getId().isEmpty()) {
            AgencyAndId id = bean.getId().indexOf("_") > -1 ? AgencyAndIdLibrary.convertFromString((String)bean.getId()) : AgencyAndIdLibrary.convertFromString((String)(agencyId + "_" + bean.getId()));
            serviceAlertRecord.setServiceAlertId(id.getId());
            serviceAlertRecord.setAgencyId(id.getAgencyId());
        }
        serviceAlertRecord.setCreationTime(bean.getCreationTime());
        serviceAlertRecord.setActiveWindows(ServiceAlertBeanHelper.getBeansAsRanges(bean.getActiveWindows()));
        serviceAlertRecord.setPublicationWindows(ServiceAlertBeanHelper.getBeansAsRanges(bean.getPublicationWindows()));
        serviceAlertRecord.setCause(ServiceAlertBeanHelper.getReasonAsCause(bean.getReason()));
        serviceAlertRecord.setConsequenceMessage(bean.getConsequenceMessage());
        serviceAlertRecord.setSummaries(new HashSet<ServiceAlertLocalizedString>());
        if (bean.getSummaries() != null) {
            for (NaturalLanguageStringBean naturalLanguageStringBean : bean.getSummaries()) {
                string = new ServiceAlertLocalizedString();
                string.setLanguage(naturalLanguageStringBean.getLang());
                string.setValue(naturalLanguageStringBean.getValue());
                string.setServiceAlertRecord(serviceAlertRecord);
                serviceAlertRecord.getSummaries().add(string);
            }
        }
        serviceAlertRecord.setDescriptions(new HashSet<ServiceAlertLocalizedString>());
        if (bean.getDescriptions() != null) {
            for (NaturalLanguageStringBean naturalLanguageStringBean : bean.getDescriptions()) {
                string = new ServiceAlertLocalizedString();
                string.setLanguage(naturalLanguageStringBean.getLang());
                string.setValue(naturalLanguageStringBean.getValue());
                string.setServiceAlertRecord(serviceAlertRecord);
                serviceAlertRecord.getDescriptions().add(string);
            }
        }
        serviceAlertRecord.setUrls(new HashSet<ServiceAlertLocalizedString>());
        if (bean.getUrls() != null) {
            for (NaturalLanguageStringBean naturalLanguageStringBean : bean.getUrls()) {
                string = new ServiceAlertLocalizedString();
                string.setLanguage(naturalLanguageStringBean.getLang());
                string.setValue(naturalLanguageStringBean.getValue());
                string.setServiceAlertRecord(serviceAlertRecord);
                serviceAlertRecord.getUrls().add(string);
            }
        }
        if (bean.getSeverity() != null) {
            serviceAlertRecord.setSeverity(bean.getSeverity());
        }
        serviceAlertRecord.setAllAffects(ServiceAlertBeanHelper.getBeanAsAffects(bean));
        for (ServiceAlertsSituationAffectsClause serviceAlertsSituationAffectsClause : serviceAlertRecord.getAllAffects()) {
            serviceAlertsSituationAffectsClause.setServiceAlertRecord(serviceAlertRecord);
        }
        serviceAlertRecord.setConsequences(ServiceAlertBeanHelper.getBeanAsConsequences(bean));
        for (ServiceAlertSituationConsequenceClause serviceAlertSituationConsequenceClause : serviceAlertRecord.getConsequences()) {
            serviceAlertSituationConsequenceClause.setServiceAlertRecord(serviceAlertRecord);
        }
        serviceAlertRecord.setSource(bean.getSource());
        return serviceAlertRecord;
    }

    public static List<TimeRangeBean> getRangesAsBeans(Set<ServiceAlertTimeRange> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return null;
        }
        ArrayList<TimeRangeBean> beans = new ArrayList<TimeRangeBean>();
        for (ServiceAlertTimeRange range : ranges) {
            TimeRangeBean bean = new TimeRangeBean();
            if (range.getFromValue() != null) {
                bean.setFrom(range.getFromValue().longValue());
            }
            if (range.getToValue() != null) {
                bean.setTo(range.getToValue().longValue());
            }
            beans.add(bean);
        }
        return beans;
    }

    public static Set<ServiceAlertTimeRange> getBeansAsRanges(List<TimeRangeBean> beans) {
        if (beans == null) {
            return Collections.emptySet();
        }
        HashSet<ServiceAlertTimeRange> ranges = new HashSet<ServiceAlertTimeRange>();
        for (TimeRangeBean bean : beans) {
            ServiceAlertTimeRange range = new ServiceAlertTimeRange();
            if (bean.getFrom() > 0L) {
                range.setFromValue(bean.getFrom());
            }
            if (bean.getTo() > 0L) {
                range.setToValue(bean.getTo());
            }
            if (range.getFromValue() == null && range.getToValue() == null) continue;
            ranges.add(range);
        }
        return ranges;
    }

    public static List<NaturalLanguageStringBean> getTranslatedStringsAsNLSBeans(Set<ServiceAlertLocalizedString> strings) {
        if (strings == null || strings.size() == 0) {
            return null;
        }
        ArrayList<NaturalLanguageStringBean> nlsBeans = new ArrayList<NaturalLanguageStringBean>();
        for (ServiceAlertLocalizedString translation : strings) {
            NaturalLanguageStringBean nls = new NaturalLanguageStringBean();
            nls.setValue(translation.getValue());
            nls.setLang(translation.getLanguage());
            nlsBeans.add(nls);
        }
        return nlsBeans;
    }

    public static List<SituationConsequenceBean> getConsequencesAsBeans(ServiceAlertRecord serviceAlert) {
        if (serviceAlert.getConsequences().size() == 0) {
            return null;
        }
        ArrayList<SituationConsequenceBean> beans = new ArrayList<SituationConsequenceBean>();
        for (ServiceAlertSituationConsequenceClause consequence : serviceAlert.getConsequences()) {
            SituationConsequenceBean bean = new SituationConsequenceBean();
            if (consequence.getEffect() != null) {
                bean.setEffect(consequence.getEffect());
            }
            if (consequence.getDetourPath() != null) {
                bean.setDetourPath(consequence.getDetourPath());
            }
            if (consequence.getDetourStopIds().size() != 0) {
                ArrayList<String> stopIds = new ArrayList<String>();
                for (String stopId : consequence.getDetourStopIds()) {
                    AgencyAndId id = ServiceAlertLibrary.agencyAndId(serviceAlert.getAgencyId(), stopId);
                    stopIds.add(AgencyAndId.convertToString((AgencyAndId)id));
                }
                bean.setDetourStopIds(stopIds);
            }
            beans.add(bean);
        }
        return beans;
    }

    public static Set<ServiceAlertSituationConsequenceClause> getBeanAsConsequences(ServiceAlertBean bean) {
        HashSet<ServiceAlertSituationConsequenceClause> consequences = new HashSet<ServiceAlertSituationConsequenceClause>();
        if (!CollectionsLibrary.isEmpty((Collection)bean.getConsequences())) {
            for (SituationConsequenceBean consequence : bean.getConsequences()) {
                ServiceAlertSituationConsequenceClause consequenceClause = new ServiceAlertSituationConsequenceClause();
                if (consequence.getEffect() != null) {
                    consequenceClause.setEffect(consequence.getEffect());
                }
                if (consequence.getDetourPath() != null) {
                    consequenceClause.setDetourPath(consequence.getDetourPath());
                }
                if (!CollectionsLibrary.isEmpty((Collection)consequence.getDetourStopIds())) {
                    HashSet<String> detourStopIds = new HashSet<String>();
                    for (String detourStopId : consequence.getDetourStopIds()) {
                        detourStopIds.add(detourStopId);
                    }
                    consequenceClause.setDetourStopIds(detourStopIds);
                }
                consequences.add(consequenceClause);
            }
        }
        return consequences;
    }

    public static List<SituationAffectsBean> getAffectsAsBeans(ServiceAlertRecord serviceAlert) {
        if (serviceAlert.getAllAffects().size() == 0) {
            return null;
        }
        ArrayList<SituationAffectsBean> beans = new ArrayList<SituationAffectsBean>();
        for (ServiceAlertsSituationAffectsClause affects : serviceAlert.getAllAffects()) {
            SituationAffectsBean bean = new SituationAffectsBean();
            if (affects.getAgencyId() != null) {
                bean.setAgencyId(affects.getAgencyId());
            }
            if (affects.getApplicationId() != null) {
                bean.setApplicationId(affects.getApplicationId());
            }
            if (affects.getRouteId() != null) {
                bean.setRouteId(affects.getRouteId());
            }
            if (affects.getDirectionId() != null) {
                bean.setDirectionId(affects.getDirectionId());
            }
            if (affects.getTripId() != null) {
                bean.setTripId(affects.getTripId());
            }
            if (affects.getStopId() != null) {
                bean.setStopId(affects.getStopId());
            }
            if (affects.getApplicationId() != null) {
                bean.setApplicationId(affects.getApplicationId());
            }
            beans.add(bean);
        }
        return beans;
    }

    public static Set<ServiceAlertsSituationAffectsClause> getBeanAsAffects(ServiceAlertBean bean) {
        HashSet<ServiceAlertsSituationAffectsClause> affectsList = new HashSet<ServiceAlertsSituationAffectsClause>();
        if (!CollectionsLibrary.isEmpty((Collection)bean.getAllAffects())) {
            for (SituationAffectsBean affectsBean : bean.getAllAffects()) {
                ServiceAlertsSituationAffectsClause affects = new ServiceAlertsSituationAffectsClause();
                if (affectsBean.getAgencyId() != null) {
                    affects.setAgencyId(affectsBean.getAgencyId());
                }
                if (affectsBean.getApplicationId() != null) {
                    affects.setApplicationId(affectsBean.getApplicationId());
                }
                if (affectsBean.getRouteId() != null) {
                    affects.setRouteId(affectsBean.getRouteId());
                }
                if (affectsBean.getDirectionId() != null) {
                    affects.setDirectionId(affectsBean.getDirectionId());
                }
                if (affectsBean.getTripId() != null) {
                    affects.setTripId(affectsBean.getTripId());
                }
                if (affectsBean.getStopId() != null) {
                    affects.setStopId(affectsBean.getStopId());
                }
                affectsList.add(affects);
            }
        }
        return affectsList;
    }

    public static String getCauseAsReason(ECause cause) {
        return cause.toString();
    }

    public static ECause getReasonAsCause(String reason) {
        if (reason == null) {
            return ECause.UNKNOWN_CAUSE;
        }
        return ECause.valueOf((String)reason);
    }

    public static List<ServiceAlertRecordBean> listRecordBeans(List<ServiceAlertRecord> serviceAlerts) {
        ArrayList<ServiceAlertRecordBean> beans = new ArrayList<ServiceAlertRecordBean>();
        for (ServiceAlertRecord serviceAlert : serviceAlerts) {
            beans.add(ServiceAlertBeanHelper.getServiceAlertAsRecordBean(serviceAlert));
        }
        return beans;
    }

    public static ServiceAlertRecordBean getServiceAlertAsRecordBean(ServiceAlertRecord serviceAlert) {
        ServiceAlertBean bean = ServiceAlertBeanHelper.getServiceAlertAsBean(serviceAlert);
        ServiceAlertRecordBean serviceAlertRecordBean = new ServiceAlertRecordBean();
        serviceAlertRecordBean.setServiceAlertBean(bean);
        serviceAlertRecordBean.setCopy(serviceAlert.isCopy());
        return serviceAlertRecordBean;
    }
}

