/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.alerts.impl;

import java.util.HashSet;
import java.util.Set;
import org.onebusaway.alerts.impl.AffectsKeyFactory;
import org.onebusaway.alerts.impl.RouteAndDirectionRef;
import org.onebusaway.alerts.impl.ServiceAlertLibrary;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertsSituationAffectsClause;
import org.onebusaway.gtfs.model.AgencyAndId;

class AffectsRouteAndDirectionKeyFactory
implements AffectsKeyFactory<RouteAndDirectionRef> {
    public static final AffectsRouteAndDirectionKeyFactory INSTANCE = new AffectsRouteAndDirectionKeyFactory();

    AffectsRouteAndDirectionKeyFactory() {
    }

    @Override
    public Set<RouteAndDirectionRef> getKeysForAffects(ServiceAlertRecord serviceAlert) {
        HashSet<RouteAndDirectionRef> routeAndDirectionRefs = new HashSet<RouteAndDirectionRef>();
        for (ServiceAlertsSituationAffectsClause affects : serviceAlert.getAllAffects()) {
            if (affects.getRouteId() == null || affects.getDirectionId() == null || affects.getStopId() != null || affects.getTripId() != null) continue;
            AgencyAndId routeId = ServiceAlertLibrary.agencyAndIdAndId(serviceAlert.getAgencyId(), affects.getRouteId());
            RouteAndDirectionRef ref = new RouteAndDirectionRef(routeId, affects.getDirectionId());
            routeAndDirectionRefs.add(ref);
        }
        return routeAndDirectionRefs;
    }
}

