/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections.beans;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.beans.PropertyMethod;
import org.onebusaway.collections.beans.PropertyMethodImpl;
import org.onebusaway.collections.beans.PropertyMethodResolver;

public class DefaultPropertyMethodResolver
implements PropertyMethodResolver {
    private static final String OBA_IFACE_PATH = "org.onebusaway.transit_data_federation.services.transit_graph.";
    private static final String OBA_IMPL_PATH = "org.onebusaway.transit_data_federation.impl.transit_graph.";
    private static Map<String, List<Method>> interfaceMethodsByKey;
    private static Map<String, String> interfaceToImplMap;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PropertyMethod getPropertyMethod(Class<?> targetType, String propertyName) {
        String methodName = "get";
        for (String part : propertyName.split(" |_")) {
            methodName = methodName + part.substring(0, 1).toUpperCase() + part.substring(1);
        }
        Method method = null;
        try {
            if (targetType.isInterface()) {
                List<Method> methods = this.getCachedInterfaceMethods(targetType, propertyName, methodName);
                if (methods.size() != 1) throw new IllegalStateException("Ambiguous implementation set for interface: " + targetType + " /" + methodName + " with potentials: " + methods + " and " + interfaceToImplMap.keySet() + " known interface mappings");
                method = methods.get(0);
            } else {
                method = targetType.getMethod(methodName, new Class[0]);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("error introspecting class: " + targetType, ex);
        }
        if (method == null) {
            throw new IllegalStateException("could not find property \"" + propertyName + "\" for type " + targetType.getName());
        }
        method.setAccessible(true);
        return new PropertyMethodImpl(method);
    }

    private List<Method> getCachedInterfaceMethods(Class<?> targetType, String propertyName, String methodName) {
        String key = this.hash(targetType, propertyName);
        if (interfaceMethodsByKey.containsKey(key)) {
            return interfaceMethodsByKey.get(key);
        }
        ScanResult scanResult = new ClassGraph().acceptPackages(new String[]{"org.onebusaway"}).enableClassInfo().scan();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (ClassInfo ci : scanResult.getClassesImplementing(targetType.getCanonicalName())) {
            try {
                if (!this.matches(ci.getName(), targetType)) continue;
                methods.add(Class.forName(ci.getName()).getMethod(methodName, new Class[0]));
            }
            catch (Exception e) {}
        }
        interfaceMethodsByKey.put(key, methods);
        return methods;
    }

    private boolean matches(String reflectedTypeName, Class<?> targetType) {
        String targetTypeName = targetType.getName();
        if (interfaceToImplMap.containsKey(targetTypeName)) {
            String implName = interfaceToImplMap.get(targetTypeName);
            return implName.equals(reflectedTypeName);
        }
        return targetTypeName.equals(reflectedTypeName);
    }

    private String hash(Class<?> targetType, String propertyName) {
        return targetType.getName() + "." + propertyName;
    }

    static {
        String[] entryInterfaces;
        interfaceMethodsByKey = new HashMap<String, List<Method>>();
        interfaceToImplMap = new HashMap<String, String>();
        interfaceToImplMap.put("org.onebusaway.gtfs.model.StopLocation", "org.onebusaway.gtfs.model.Stop");
        for (String interfaceName : entryInterfaces = new String[]{"AgencyEntry", "BlockConfigurationEntry", "BlockEntry", "BlockStopTimeEntry", "BlockTripEntry", "FrequencyBlockStopTimeEntry", "FrequencyEntry", "RouteCollectionEntry", "RouteEntry", "StopEntry", "StopTimeEntry", "TripEntry"}) {
            interfaceToImplMap.put(OBA_IFACE_PATH + interfaceName, OBA_IMPL_PATH + interfaceName + "Impl");
        }
    }
}

