/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class FactoryMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private IValueFactory<K, V> _valueFactory;

    public static <K, V> Map<K, V> create(Map<K, V> map, V defaultValue) {
        return new MapImpl<K, V>(map, new ClassInstanceFactory(defaultValue.getClass()));
    }

    public static <K, V> Map<K, V> create(Map<K, V> map, IValueFactory<K, V> factory) {
        return new MapImpl<K, V>(map, factory);
    }

    public static <K, V> SortedMap<K, V> createSorted(SortedMap<K, V> map, V defaultValue) {
        return new SortedMapImpl<K, V>(map, new ClassInstanceFactory(defaultValue.getClass()));
    }

    public static <K, V> SortedMap<K, V> createSorted(SortedMap<K, V> map, IValueFactory<K, V> factory) {
        return new SortedMapImpl<K, V>(map, factory);
    }

    public FactoryMap(V factoryInstance) {
        this(new ClassInstanceFactory(factoryInstance.getClass()));
    }

    public FactoryMap(IValueFactory<K, V> valueFactory) {
        this._valueFactory = valueFactory;
    }

    @Override
    public V get(Object key) {
        if (!this.containsKey(key)) {
            this.put(key, this.createValue(key));
        }
        return super.get(key);
    }

    private V createValue(K key) {
        return this._valueFactory.create(key);
    }

    private static class SortedMapImpl<K, V>
    extends MapImpl<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = 1L;
        private SortedMap<K, V> _source;

        public SortedMapImpl(SortedMap<K, V> source, IValueFactory<K, V> valueFactory) {
            super(source, valueFactory);
            this._source = source;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this._source.comparator();
        }

        @Override
        public K firstKey() {
            return this._source.firstKey();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return this._source.headMap(toKey);
        }

        @Override
        public K lastKey() {
            return this._source.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this._source.subMap(fromKey, toKey);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return this._source.tailMap(fromKey);
        }
    }

    private static class MapImpl<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<K, V> _source;
        private IValueFactory<K, V> _valueFactory;

        public MapImpl(Map<K, V> source, IValueFactory<K, V> valueFactory) {
            this._source = source;
            this._valueFactory = valueFactory;
        }

        @Override
        public void clear() {
            this._source.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this._source.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this._source.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this._source.entrySet();
        }

        @Override
        public V get(Object key) {
            if (!this.containsKey(key)) {
                this._source.put(key, this.createValue(key));
            }
            return this._source.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this._source.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this._source.keySet();
        }

        @Override
        public V put(K key, V value) {
            return this._source.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            this._source.putAll(t);
        }

        @Override
        public V remove(Object key) {
            return this._source.remove(key);
        }

        @Override
        public int size() {
            return this._source.size();
        }

        @Override
        public Collection<V> values() {
            return this._source.values();
        }

        private V createValue(K key) {
            return this._valueFactory.create(key);
        }
    }

    private static class ClassInstanceFactory<K, V>
    implements IValueFactory<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Class<? extends V> _valueClass;

        public ClassInstanceFactory(Class valueClass) {
            this._valueClass = valueClass;
        }

        @Override
        public V create(K key) {
            try {
                return this._valueClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static interface IValueFactory<KF, VF> {
        public VF create(KF var1);
    }
}

