/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.validator;

import com.conveyal.gtfs.model.InvalidValue;
import com.conveyal.gtfs.model.ValidationResult;
import com.conveyal.gtfs.service.CalendarDateVerificationService;
import com.conveyal.gtfs.service.GtfsValidationService;
import com.conveyal.gtfs.service.impl.GtfsStatisticsService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.services.GenericMutableDao;

public class ValidatorMain {
    public static String SILENT_MODE = "validate.silent";

    public static void main(String[] args) {
        if (args.length != 1) {
            ValidatorMain.logError("Usage: gtfs-validator /path/to/gtfs.zip");
            System.exit(-1);
        }
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            handler.setLevel(Level.OFF);
        }
        File inputGtfs = new File(args[0]);
        ValidatorMain.logError("Reading GTFS from " + inputGtfs.getPath());
        GtfsRelationalDaoImpl dao = new GtfsRelationalDaoImpl();
        GtfsReader reader = new GtfsReader();
        try {
            reader.setInputLocation(inputGtfs);
            reader.setEntityStore((GenericMutableDao)dao);
            reader.run();
        }
        catch (IOException e) {
            ValidatorMain.logError("Could not read file " + inputGtfs.getPath() + "; does it exist and is it readable?");
            System.exit(-1);
        }
        ValidatorMain.logError("Read GTFS");
        if (dao.getAllTrips().size() == 0) {
            ValidatorMain.logError("No Trips Found in GTFS, exiting");
            System.exit(-1);
        }
        GtfsValidationService validationService = new GtfsValidationService(dao);
        CalendarDateVerificationService calendarDateVerService = new CalendarDateVerificationService(dao);
        ValidatorMain.logError("Validating routes");
        ValidationResult routes = validationService.validateRoutes();
        ValidatorMain.logError("Validating trips");
        ValidationResult trips = validationService.validateTrips();
        ValidatorMain.logError("Checking for duplicate stops");
        ValidationResult stops = validationService.duplicateStops();
        ValidatorMain.logError("Checking for problems with shapes");
        ValidationResult shapes = validationService.listReversedTripShapes();
        shapes.append(validationService.listStopsAwayFromShape(130.0));
        ValidatorMain.logError("Checking for dates with no trips");
        ValidationResult dates = calendarDateVerService.getCalendarProblems();
        ValidatorMain.logError("Calculating statistics");
        StringBuilder sb = new StringBuilder(256);
        sb.append("# Validation report for ");
        ArrayList agencies = new ArrayList(dao.getAllAgencies());
        int size = agencies.size();
        for (int i = 0; i < size; ++i) {
            sb.append(((Agency)agencies.get(i)).getName());
            if (size - i == 1) continue;
            if (size - i == 2) {
                sb.append(" and ");
                continue;
            }
            sb.append(", ");
        }
        ValidatorMain.log(sb.toString());
        ValidatorMain.log("## Feed statistics");
        GtfsStatisticsService stats = new GtfsStatisticsService(dao);
        ValidatorMain.log("- " + stats.getAgencyCount() + " agencies");
        ValidatorMain.log("- " + stats.getRouteCount() + " routes");
        ValidatorMain.log("- " + stats.getTripCount() + " trips");
        ValidatorMain.log("- " + stats.getStopCount() + " stops");
        ValidatorMain.log("- " + stats.getStopTimesCount() + " stop times");
        Optional<Date> calDateStart = stats.getCalendarDateStart();
        Date calSvcStart = stats.getCalendarServiceRangeStart();
        Optional<Date> calDateEnd = stats.getCalendarDateEnd();
        Date calSvcEnd = stats.getCalendarServiceRangeEnd();
        Date feedSvcStart = ValidatorMain.getEarliestDate(calDateStart, calSvcStart);
        Date feedSvcEnd = ValidatorMain.getLatestDate(calDateEnd, calSvcEnd);
        ValidatorMain.log("\nFeed has service from " + feedSvcStart + " to " + feedSvcEnd);
        ValidatorMain.log("## Validation Results");
        ValidatorMain.log("- Routes: " + ValidatorMain.getValidationSummary(routes));
        ValidatorMain.log("- Trips: " + ValidatorMain.getValidationSummary(trips));
        ValidatorMain.log("- Stops: " + ValidatorMain.getValidationSummary(stops));
        ValidatorMain.log("- Shapes: " + ValidatorMain.getValidationSummary(shapes));
        ValidatorMain.log("- Dates: " + ValidatorMain.getValidationSummary(dates));
        ValidatorMain.log("\n### Routes");
        ValidatorMain.log(ValidatorMain.getValidationReport(routes));
        ValidatorMain.log("\n### Trips");
        ValidatorMain.log(ValidatorMain.getValidationReport(trips));
        ValidatorMain.log("\n### Stops");
        ValidatorMain.log(ValidatorMain.getValidationReport(stops));
        ValidatorMain.log("\n### Shapes");
        ValidatorMain.log(ValidatorMain.getValidationReport(shapes));
        ValidatorMain.log("\n### Dates");
        ValidatorMain.log(ValidatorMain.getValidationReport(dates));
        ValidatorMain.log("\n### Active Calendars");
        ValidatorMain.log(calendarDateVerService.getTripDataForEveryDay());
    }

    public static String getValidationSummary(ValidationResult result) {
        return result.invalidValues.size() + " errors/warnings";
    }

    public static String getValidationReport(ValidationResult result) {
        if (result.invalidValues.size() == 0) {
            return "Hooray! No errors here (at least, none that we could find).\n";
        }
        StringBuilder sb = new StringBuilder(256);
        int i = 0;
        int MAX_PRINT = 128;
        for (InvalidValue v : result.invalidValues) {
            if (++i > MAX_PRINT) {
                sb.append("And Many More...");
                break;
            }
            sb.append("- ");
            sb.append(v.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    static Date getEarliestDate(Optional<Date> o, Date d) {
        if (o.isPresent()) {
            d = o.get().before(d) ? o.get() : d;
        }
        return d;
    }

    static Date getLatestDate(Optional<Date> o, Date d) {
        if (o.isPresent()) {
            d = o.get().after(d) ? o.get() : d;
        }
        return d;
    }

    static void logError(String msg) {
        if (!"true".equals(System.getProperty(SILENT_MODE))) {
            System.err.println(msg);
        }
    }

    static void log(String msg) {
        if (!"true".equals(System.getProperty(SILENT_MODE))) {
            System.out.println(msg);
        }
    }
}

