/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.service.impl;

import com.conveyal.gtfs.model.Statistic;
import com.conveyal.gtfs.service.StatisticsService;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;

public class GtfsStatisticsService
implements StatisticsService {
    private GtfsRelationalDaoImpl gtfsDao = null;

    public GtfsStatisticsService(GtfsRelationalDaoImpl dao) {
        this.gtfsDao = dao;
    }

    @Override
    public Integer getAgencyCount() {
        return this.gtfsDao.getAllAgencies().size();
    }

    @Override
    public Integer getRouteCount() {
        return this.gtfsDao.getAllRoutes().size();
    }

    @Override
    public Integer getTripCount() {
        return this.gtfsDao.getAllTrips().size();
    }

    @Override
    public Integer getStopCount() {
        return this.gtfsDao.getAllStops().size();
    }

    @Override
    public Integer getStopTimesCount() {
        return this.gtfsDao.getAllStopTimes().size();
    }

    @Override
    public Date getCalendarServiceRangeStart() {
        Date startDate = null;
        for (ServiceCalendar serviceCalendar : this.gtfsDao.getAllCalendars()) {
            if (startDate != null && !serviceCalendar.getStartDate().getAsDate().before(startDate)) continue;
            startDate = serviceCalendar.getStartDate().getAsDate();
        }
        if (startDate != null) {
            return startDate;
        }
        return this.getCalendarDateStart().orElseThrow(IllegalStateException::new);
    }

    @Override
    public Date getCalendarServiceRangeEnd() {
        Date endDate = null;
        for (ServiceCalendar serviceCalendar : this.gtfsDao.getAllCalendars()) {
            if (endDate != null && !serviceCalendar.getEndDate().getAsDate().after(endDate)) continue;
            endDate = serviceCalendar.getEndDate().getAsDate();
        }
        if (endDate != null) {
            return endDate;
        }
        return this.getCalendarDateEnd().orElseThrow(IllegalStateException::new);
    }

    @Override
    public Optional<Date> getCalendarDateStart() {
        Optional<Date> startDate = Optional.empty();
        for (ServiceCalendarDate serviceCalendarDate : this.gtfsDao.getAllCalendarDates()) {
            if (startDate.isPresent() && !serviceCalendarDate.getDate().getAsDate().before(startDate.get())) continue;
            startDate = Optional.of(serviceCalendarDate.getDate().getAsDate());
        }
        return startDate;
    }

    @Override
    public Optional<Date> getCalendarDateEnd() {
        Optional<Date> endDate = Optional.empty();
        for (ServiceCalendarDate serviceCalendarDate : this.gtfsDao.getAllCalendarDates()) {
            if (endDate.isPresent() && !serviceCalendarDate.getDate().getAsDate().after(endDate.get())) continue;
            endDate = Optional.of(serviceCalendarDate.getDate().getAsDate());
        }
        return endDate;
    }

    public Collection<Agency> getAllAgencies() {
        return this.gtfsDao.getAllAgencies();
    }

    @Override
    public Integer getRouteCount(String agencyId) {
        int count = 0;
        Collection routes = this.gtfsDao.getAllRoutes();
        for (Route route : routes) {
            if (!agencyId.equals(route.getAgency().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Integer getTripCount(String agencyId) {
        int count = 0;
        Collection trips = this.gtfsDao.getAllTrips();
        for (Trip trip : trips) {
            if (!agencyId.equals(trip.getRoute().getAgency().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Integer getStopCount(String agencyId) {
        int count = 0;
        Collection stops = this.gtfsDao.getAllStops();
        for (Stop stop : stops) {
            AgencyAndId id = stop.getId();
            if (!agencyId.equals(id.getAgencyId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Integer getStopTimesCount(String agencyId) {
        int count = 0;
        Collection stopTimes = this.gtfsDao.getAllStopTimes();
        for (StopTime stopTime : stopTimes) {
            if (!agencyId.equals(stopTime.getTrip().getRoute().getAgency().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Date getCalendarServiceRangeStart(String agencyId) {
        Date startDate = null;
        for (ServiceCalendar serviceCalendar : this.gtfsDao.getAllCalendars()) {
            if (!agencyId.equals(serviceCalendar.getServiceId().getAgencyId()) || startDate != null && !serviceCalendar.getStartDate().getAsDate().before(startDate)) continue;
            startDate = serviceCalendar.getStartDate().getAsDate();
        }
        return startDate;
    }

    @Override
    public Date getCalendarServiceRangeEnd(String agencyId) {
        Date endDate = null;
        for (ServiceCalendar serviceCalendar : this.gtfsDao.getAllCalendars()) {
            if (!agencyId.equals(serviceCalendar.getServiceId().getAgencyId()) || endDate != null && !serviceCalendar.getEndDate().getAsDate().after(endDate)) continue;
            endDate = serviceCalendar.getEndDate().getAsDate();
        }
        return endDate;
    }

    @Override
    public Date getCalendarDateStart(String agencyId) {
        Date startDate = null;
        for (ServiceCalendarDate serviceCalendarDate : this.gtfsDao.getAllCalendarDates()) {
            if (!agencyId.equals(serviceCalendarDate.getServiceId().getAgencyId()) || startDate != null && !serviceCalendarDate.getDate().getAsDate().before(startDate)) continue;
            startDate = serviceCalendarDate.getDate().getAsDate();
        }
        return startDate;
    }

    @Override
    public Date getCalendarDateEnd(String agencyId) {
        Date endDate = null;
        for (ServiceCalendarDate serviceCalendarDate : this.gtfsDao.getAllCalendarDates()) {
            if (!agencyId.equals(serviceCalendarDate.getServiceId().getAgencyId()) || endDate != null && !serviceCalendarDate.getDate().getAsDate().after(endDate)) continue;
            endDate = serviceCalendarDate.getDate().getAsDate();
        }
        return endDate;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D ret = null;
        for (Stop stop : this.gtfsDao.getAllStops()) {
            if (ret == null) {
                ret = new Rectangle2D.Double(stop.getLon(), stop.getLat(), 0.0, 0.0);
                continue;
            }
            ret.add(new Point2D.Double(stop.getLon(), stop.getLat()));
        }
        return ret;
    }

    @Override
    public Statistic getStatistic(String agencyId) {
        Statistic gs = new Statistic();
        gs.setAgencyId(agencyId);
        gs.setRouteCount(this.getRouteCount(agencyId));
        gs.setTripCount(this.getTripCount(agencyId));
        gs.setStopCount(this.getStopCount(agencyId));
        gs.setStopTimeCount(this.getStopTimesCount(agencyId));
        gs.setCalendarStartDate(this.getCalendarDateStart(agencyId));
        gs.setCalendarEndDate(this.getCalendarDateEnd(agencyId));
        gs.setCalendarServiceStart(this.getCalendarServiceRangeStart(agencyId));
        gs.setCalendarServiceEnd(this.getCalendarServiceRangeEnd(agencyId));
        gs.setBounds(this.getBounds());
        return gs;
    }

    public String getStatisticAsCSV(String agencyId) {
        Statistic s = this.getStatistic(agencyId);
        return GtfsStatisticsService.formatStatisticAsCSV(s);
    }

    public static String formatStatisticAsCSV(Statistic s) {
        StringBuffer buff = new StringBuffer();
        buff.append(s.getAgencyId());
        buff.append(",");
        buff.append(s.getRouteCount());
        buff.append(",");
        buff.append(s.getTripCount());
        buff.append(",");
        buff.append(s.getStopCount());
        buff.append(",");
        buff.append(s.getStopTimeCount());
        buff.append(",");
        buff.append(s.getCalendarServiceStart());
        buff.append(",");
        buff.append(s.getCalendarServiceEnd());
        buff.append(",");
        buff.append(s.getCalendarStartDate());
        buff.append(",");
        buff.append(s.getCalendarEndDate());
        return buff.toString();
    }

    private ZoneId getTimeZone() {
        CalendarService calendarService = CalendarServiceDataFactoryImpl.createService((GtfsRelationalDao)this.gtfsDao);
        TimeZone tz = calendarService.getTimeZoneForAgencyId(((Agency)this.gtfsDao.getAllAgencies().iterator().next()).getId());
        return tz.toZoneId();
    }

    @Override
    @Deprecated
    public Integer getNumberOfDays() {
        Duration d = Duration.between(this.getCalendarServiceRangeStart().toInstant().atZone(this.getTimeZone()).toInstant(), this.getCalendarServiceRangeEnd().toInstant().atZone(this.getTimeZone()).toInstant());
        return (int)d.toDays() + 1;
    }
}

