/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.service;

import com.conveyal.gtfs.model.HumanReadableServiceID;
import java.util.HashMap;

public class ServiceIdHelper {
    public HumanReadableServiceID getHumanReadableCalendarFromServiceId(String id) {
        HumanReadableServiceID sid = new HumanReadableServiceID();
        try {
            String[] serviceIdParts = id.split("_");
            if (serviceIdParts.length != 3 && (serviceIdParts = id.split("-")).length > 1) {
                sid.setServiceId(id);
            }
            String[] serviceIdSubparts = serviceIdParts[2].split("-");
            String[] depotParts = serviceIdParts[1].split("-");
            sid.setDepot(depotParts[depotParts.length - 1]);
            String pickCode = serviceIdSubparts[0].toUpperCase();
            char pickCodeWithoutYear = pickCode.toCharArray()[0];
            if (pickCodeWithoutYear <= 'G') {
                if (id.contains("Weekday")) {
                    if (id.contains("SDon")) {
                        sid.setServiceId("WEEKDAY_SCHOOL_OPEN");
                    } else {
                        sid.setServiceId("WEEKDAY_SCHOOL_CLOSED");
                    }
                } else if (id.contains("Saturday")) {
                    sid.setServiceId("SATURDAY");
                } else if (id.contains("Sunday")) {
                    sid.setServiceId("SUNDAY");
                } else {
                    sid.setServiceId(null);
                }
            } else {
                sid.setServiceId(ServiceCode.serviceCodeForGtfsId.get(Character.toString(pickCodeWithoutYear)).name());
            }
            if (id.contains("BM") || id.contains("b4")) {
                sid.appendToServiceId(" Next Day's Trips Starting Before Midnight");
            }
        }
        catch (Exception e) {
            sid.setServiceId(id);
        }
        return sid;
    }

    private static enum ServiceCode {
        WEEKDAY_SCHOOL_OPEN,
        WEEKDAY_SCHOOL_CLOSED,
        SATURDAY,
        SUNDAY,
        MLK,
        PRESIDENTS_DAY,
        MEMORIAL_DAY,
        GOOD_FRIDAY,
        LABOR_DAY,
        JULY_FOURTH,
        COLUMBUS_DAY,
        THANKSGIVING,
        DAY_AFTER_THANKSGIVING,
        CHRISTMAS_EVE,
        CHRISTMAS_DAY,
        CHRISTMAS_DAY_OBSERVED,
        CHRISTMAS_WEEK,
        NEW_YEARS_EVE,
        NEW_YEARS_DAY,
        NEW_YEARS_DAY_OBSERVED;

        static HashMap<String, ServiceCode> serviceCodeForGtfsId;
        static HashMap<ServiceCode, String> letterCodeForServiceCode;

        private static void mapServiceCode(String string, ServiceCode serviceCode) {
            serviceCodeForGtfsId.put(string, serviceCode);
            if (Character.isLetter(string.charAt(0))) {
                letterCodeForServiceCode.put(serviceCode, string);
            }
        }

        static {
            serviceCodeForGtfsId = new HashMap();
            letterCodeForServiceCode = new HashMap();
            ServiceCode.mapServiceCode("1", WEEKDAY_SCHOOL_OPEN);
            ServiceCode.mapServiceCode("11", WEEKDAY_SCHOOL_CLOSED);
            ServiceCode.mapServiceCode("2", SATURDAY);
            ServiceCode.mapServiceCode("3", SUNDAY);
            ServiceCode.mapServiceCode("H", MLK);
            ServiceCode.mapServiceCode("I", PRESIDENTS_DAY);
            ServiceCode.mapServiceCode("J", GOOD_FRIDAY);
            ServiceCode.mapServiceCode("K", MEMORIAL_DAY);
            ServiceCode.mapServiceCode("M", JULY_FOURTH);
            ServiceCode.mapServiceCode("N", LABOR_DAY);
            ServiceCode.mapServiceCode("O", COLUMBUS_DAY);
            ServiceCode.mapServiceCode("R", THANKSGIVING);
            ServiceCode.mapServiceCode("S", DAY_AFTER_THANKSGIVING);
            ServiceCode.mapServiceCode("T", CHRISTMAS_EVE);
            ServiceCode.mapServiceCode("U", CHRISTMAS_DAY);
            ServiceCode.mapServiceCode("V", CHRISTMAS_DAY_OBSERVED);
            ServiceCode.mapServiceCode("W", CHRISTMAS_WEEK);
            ServiceCode.mapServiceCode("X", NEW_YEARS_EVE);
            ServiceCode.mapServiceCode("Y", NEW_YEARS_DAY);
            ServiceCode.mapServiceCode("Z", NEW_YEARS_DAY_OBSERVED);
        }
    }
}

