/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.service;

import com.conveyal.gtfs.model.BlockInterval;
import com.conveyal.gtfs.model.DuplicateStops;
import com.conveyal.gtfs.model.InvalidValue;
import com.conveyal.gtfs.model.Priority;
import com.conveyal.gtfs.model.TripPatternCollection;
import com.conveyal.gtfs.model.ValidationResult;
import com.conveyal.gtfs.model.comparators.BlockIntervalComparator;
import com.conveyal.gtfs.model.comparators.StopTimeComparator;
import com.conveyal.gtfs.service.GeoUtils;
import com.conveyal.gtfs.service.impl.GtfsStatisticsService;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;

public class GtfsValidationService {
    static GeometryFactory geometryFactory = new GeometryFactory();
    private GtfsRelationalDaoImpl gtfsDao = null;
    private GtfsStatisticsService statsService = null;

    public GtfsValidationService(GtfsRelationalDaoImpl dao) {
        this.gtfsDao = dao;
        this.statsService = new GtfsStatisticsService(dao);
    }

    public ValidationResult validateRoutes() {
        ValidationResult result = new ValidationResult();
        for (Route route : this.gtfsDao.getAllRoutes()) {
            String routeId = route.getId().toString();
            String shortName = "";
            String longName = "";
            String desc = "";
            if (route.getShortName() != null) {
                shortName = route.getShortName().trim().toLowerCase();
            }
            if (route.getLongName() != null) {
                longName = route.getLongName().trim().toLowerCase();
            }
            if (route.getDesc() != null) {
                desc = route.getDesc().toLowerCase();
            }
            if (longName.isEmpty() && shortName.isEmpty()) {
                result.add(new InvalidValue("route", "route_short_name,route_long_name", routeId, "RouteShortAndLongNamesAreBlank", "", null, Priority.HIGH));
            }
            if (shortName.length() > 9) {
                result.add(new InvalidValue("route", "route_short_name", routeId, "ValidateRouteShortNameIsTooLong", "route_short_name is " + shortName.length() + " chars ('" + shortName + "')", null, Priority.MEDIUM));
            }
            if (!longName.isEmpty() && !shortName.isEmpty() && longName.contains(shortName)) {
                result.add(new InvalidValue("route", "route_short_name,route_long_name", routeId, "ValidateRouteLongNameContainShortName", "'" + longName + "' contains '" + shortName + "'", null, Priority.MEDIUM));
            }
            if (!desc.isEmpty() && (desc.equals(shortName) || desc.equals(longName))) {
                result.add(new InvalidValue("route", "route_short_name,route_long_name,route_desc", routeId, "ValidateRouteDescriptionSameAsRouteName", "", null, Priority.MEDIUM));
            }
            if (route.getType() >= 0 && route.getType() <= 7) continue;
            result.add(new InvalidValue("route", "route_type", routeId, "ValidateRouteTypeInvalidValid", "route_type is " + route.getType(), null, Priority.HIGH));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public ValidationResult validateTrips() {
        String tripId;
        ValidationResult result = new ValidationResult();
        HashMap tripStopTimes = new HashMap(this.statsService.getStopTimesCount() * 2);
        HashSet<String> usedStopIds = new HashSet<String>(this.statsService.getStopCount() * 2);
        for (StopTime stopTime : this.gtfsDao.getAllStopTimes()) {
            tripId = stopTime.getTrip().getId().toString();
            if (!tripStopTimes.containsKey(tripId)) {
                tripStopTimes.put(tripId, new ArrayList());
            }
            ((ArrayList)tripStopTimes.get(tripId)).add(stopTime);
            if (stopTime.getStop() == null || stopTime.getStop().getId() == null) continue;
            usedStopIds.add(stopTime.getStop().getId().toString());
        }
        int reasonableNumberOfDates = this.statsService.getNumberOfDays() * 2;
        HashMap serviceCalendarDates = new HashMap(reasonableNumberOfDates);
        for (ServiceCalendar calendar : this.gtfsDao.getAllCalendars()) {
            void var12_16;
            Date startDate = calendar.getStartDate().getAsDate();
            Date endDate = calendar.getEndDate().getAsDate();
            HashSet<void> datesActive = new HashSet<void>(reasonableNumberOfDates);
            Date date = startDate;
            HashSet<Integer> daysActive = new HashSet<Integer>();
            if (calendar.getSunday() == 1) {
                daysActive.add(1);
            } else if (calendar.getMonday() == 1) {
                daysActive.add(2);
            } else if (calendar.getTuesday() == 1) {
                daysActive.add(3);
            } else if (calendar.getWednesday() == 1) {
                daysActive.add(4);
            } else if (calendar.getThursday() == 1) {
                daysActive.add(5);
            } else if (calendar.getFriday() == 1) {
                daysActive.add(6);
            } else if (calendar.getSaturday() == 1) {
                daysActive.add(7);
            }
            while (var12_16.before(endDate) || var12_16.equals(endDate)) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)var12_16);
                if (daysActive.contains(cal.get(7))) {
                    datesActive.add(var12_16);
                }
                cal.add(5, 1);
                Date date2 = cal.getTime();
            }
            serviceCalendarDates.put(calendar.getServiceId().getId(), datesActive);
        }
        for (ServiceCalendarDate calendarDate : this.gtfsDao.getAllCalendarDates()) {
            String serviceId = calendarDate.getServiceId().getId();
            int exceptionType = calendarDate.getExceptionType();
            if (serviceCalendarDates.containsKey(serviceId)) {
                if (exceptionType == 1) {
                    ((HashSet)serviceCalendarDates.get(serviceId)).add(calendarDate.getDate().getAsDate());
                    continue;
                }
                if (exceptionType != 2 || !((HashSet)serviceCalendarDates.get(serviceId)).contains(calendarDate.getDate().getAsDate())) continue;
                ((HashSet)serviceCalendarDates.get(serviceId)).remove(calendarDate.getDate().getAsDate());
                continue;
            }
            if (exceptionType != 1) continue;
            HashSet<Date> calendarDates = new HashSet<Date>();
            calendarDates.add(calendarDate.getDate().getAsDate());
            serviceCalendarDates.put(serviceId, calendarDates);
        }
        for (Stop stop : this.gtfsDao.getAllStops()) {
            String stopId = stop.getId().toString();
            if (usedStopIds.contains(stopId)) continue;
            result.add(new InvalidValue("stop", "stop_id", stopId, "UnusedStop", "Stop Id " + stopId + " is not used in any trips.", null, Priority.LOW));
        }
        HashMap blockIntervals = new HashMap();
        HashMap<String, String> duplicateTripHash = new HashMap<String, String>();
        for (Trip trip : this.gtfsDao.getAllTrips()) {
            InvalidValue iv;
            Object stopTime22;
            tripId = trip.getId().toString();
            ArrayList stopTimes = (ArrayList)tripStopTimes.get(tripId);
            if (stopTimes == null || stopTimes.isEmpty()) {
                InvalidValue iv2 = new InvalidValue("trip", "trip_id", tripId, "NoStopTimesForTrip", "Trip Id " + tripId + " has no stop times.", null, Priority.HIGH);
                iv2.route = trip.getRoute();
                result.add(iv2);
                continue;
            }
            Collections.sort(stopTimes, new StopTimeComparator());
            StopTime previousStopTime = null;
            for (Object stopTime22 : stopTimes) {
                if (stopTime22.getDepartureTime() < stopTime22.getArrivalTime()) {
                    iv = new InvalidValue("stop_time", "trip_id", tripId, "StopTimeDepartureBeforeArrival", "Trip Id " + tripId + " stop sequence " + stopTime22.getStopSequence() + " departs before arriving.", null, Priority.HIGH);
                    iv.route = trip.getRoute();
                    result.add(iv);
                }
                if (previousStopTime != null && stopTime22.getArrivalTime() > 0 && stopTime22.getArrivalTime() < previousStopTime.getDepartureTime()) {
                    System.out.println(stopTime22.getArrivalTime());
                    iv = new InvalidValue("stop_time", "trip_id", tripId, "StopTimesOutOfSequence", "Trip Id " + tripId + " stop sequence " + stopTime22.getStopSequence() + " arrives before departing " + previousStopTime.getStopSequence(), null, Priority.HIGH);
                    iv.route = trip.getRoute();
                    result.add(iv);
                    break;
                }
                previousStopTime = stopTime22;
            }
            String blockId = "";
            if (trip.getBlockId() != null) {
                blockId = trip.getBlockId();
            }
            if (!blockId.isEmpty()) {
                BlockInterval blockInterval = new BlockInterval();
                blockInterval.setTrip(trip);
                blockInterval.setStartTime(((StopTime)stopTimes.get(0)).getDepartureTime());
                blockInterval.setFirstStop((StopTime)stopTimes.get(0));
                blockInterval.setLastStop((StopTime)stopTimes.get(stopTimes.size() - 1));
                if (!blockIntervals.containsKey(blockId)) {
                    blockIntervals.put(blockId, new ArrayList());
                }
                ((ArrayList)blockIntervals.get(blockId)).add(blockInterval);
            }
            String stopIds = "";
            stopTime22 = stopTimes.iterator();
            while (stopTime22.hasNext()) {
                StopTime stopTime3 = (StopTime)stopTime22.next();
                if (stopTime3.getStop() == null || stopTime3.getStop().getId() == null) continue;
                stopIds = stopIds + stopTime3.getStop().getId().toString() + ",";
            }
            String tripKey = trip.getServiceId().getId() + "_" + blockId + "_" + ((StopTime)stopTimes.get(0)).getDepartureTime() + "_" + ((StopTime)stopTimes.get(stopTimes.size() - 1)).getArrivalTime() + "_" + stopIds;
            if (duplicateTripHash.containsKey(tripKey)) {
                String duplicateTripId = (String)duplicateTripHash.get(tripKey);
                iv = new InvalidValue("trip", "trip_id", tripId, "DuplicateTrip", "Trip Ids " + duplicateTripId + " & " + tripId + " are duplicates", null, Priority.LOW);
                iv.route = trip.getRoute();
                result.add(iv);
                continue;
            }
            duplicateTripHash.put(tripKey, tripId);
        }
        for (Map.Entry entry : blockIntervals.entrySet()) {
            String blockId = (String)entry.getKey();
            ArrayList intervals = (ArrayList)blockIntervals.get(blockId);
            Collections.sort(intervals, new BlockIntervalComparator());
            int iOffset = 0;
            for (BlockInterval i1 : intervals) {
                block10: for (BlockInterval i2 : intervals.subList(iOffset, intervals.size() - 1)) {
                    String tripId2;
                    String tripId1 = i1.getTrip().getId().toString();
                    if (tripId1.equals(tripId2 = i2.getTrip().getId().toString()) || i1.getLastStop().getDepartureTime() <= i2.getFirstStop().getArrivalTime() || i2.getLastStop().getDepartureTime() <= i1.getFirstStop().getArrivalTime()) continue;
                    if (i1.getTrip().getServiceId().getId().equals(i2.getTrip().getServiceId().getId())) {
                        if (result.containsBoth(tripId1, tripId2, "trip")) continue;
                        InvalidValue iv = new InvalidValue("trip", "block_id", blockId, "OverlappingTripsInBlock", "Trip Ids " + tripId1 + " & " + tripId2 + " overlap and share block Id " + blockId, null, Priority.HIGH);
                        iv.route = i1.getTrip().getRoute();
                        result.add(iv);
                        continue;
                    }
                    for (Date d1 : (HashSet)serviceCalendarDates.get(i1.getTrip().getServiceId().getId())) {
                        if (!((HashSet)serviceCalendarDates.get(i2.getTrip().getServiceId().getId())).contains(d1)) continue;
                        InvalidValue iv = new InvalidValue("trip", "block_id", blockId, "OverlappingTripsInBlock", "Trip Ids " + tripId1 + " & " + tripId2 + " overlap and share block Id " + blockId, null, Priority.HIGH);
                        iv.route = i1.getTrip().getRoute();
                        result.add(iv);
                        continue block10;
                    }
                }
            }
        }
        result.append(this.listReversedTripShapes());
        return result;
    }

    public ValidationResult duplicateStops() {
        return this.duplicateStops(2.0);
    }

    public ValidationResult duplicateStops(Double bufferDistance) {
        ValidationResult result = new ValidationResult();
        Collection stops = this.gtfsDao.getAllStops();
        STRtree stopIndex = new STRtree();
        HashMap<String, Geometry> stopProjectedGeomMap = new HashMap<String, Geometry>(this.statsService.getStopCount() * 2);
        for (Stop stop : stops) {
            try {
                Geometry geom = GeoUtils.getGeometryFromCoordinate(stop.getLat(), stop.getLon());
                stopIndex.insert(geom.getEnvelopeInternal(), (Object)stop);
                stopProjectedGeomMap.put(stop.getId().toString(), geom);
            }
            catch (IllegalArgumentException iae) {
                result.add(new InvalidValue("stop", "duplicateStops", stop.toString(), "MissingCoordinates", "stop " + stop + " is missing coordinates", null, Priority.MEDIUM));
            }
        }
        stopIndex.build();
        ArrayList<DuplicateStops> duplicateStops = new ArrayList<DuplicateStops>();
        for (Geometry stopGeom : stopProjectedGeomMap.values()) {
            Geometry bufferedStopGeom = stopGeom.buffer(bufferDistance.doubleValue());
            List stopCandidates = stopIndex.query(bufferedStopGeom.getEnvelopeInternal());
            if (stopCandidates.size() <= 1) continue;
            for (Stop stop1 : stopCandidates) {
                for (Stop stop2 : stopCandidates) {
                    Geometry stop2Geom;
                    Geometry stop1Geom;
                    double distance;
                    if (stop1.getId() == stop2.getId()) continue;
                    Boolean stopPairAlreadyFound = false;
                    for (DuplicateStops duplicate : duplicateStops) {
                        if ((!duplicate.stop1.getId().getAgencyId().equals(stop1.getId().getAgencyId()) || !duplicate.stop2.getId().getAgencyId().equals(stop2.getId().getAgencyId())) && (!duplicate.stop2.getId().getAgencyId().equals(stop1.getId().getAgencyId()) || !duplicate.stop1.getId().getAgencyId().equals(stop2.getId().getAgencyId()))) continue;
                        stopPairAlreadyFound = true;
                    }
                    if (stopPairAlreadyFound.booleanValue() || !((distance = (stop1Geom = (Geometry)stopProjectedGeomMap.get(stop1.getId().toString())).distance(stop2Geom = (Geometry)stopProjectedGeomMap.get(stop2.getId().toString()))) <= bufferDistance)) continue;
                    DuplicateStops duplicateStop = new DuplicateStops(stop1, stop2, distance);
                    duplicateStops.add(duplicateStop);
                    result.add(new InvalidValue("stop", "stop_lat,stop_lon", duplicateStop.getStopIds(), "DuplicateStops", duplicateStop.toString(), duplicateStop, Priority.LOW));
                }
            }
        }
        return result;
    }

    public ValidationResult listReversedTripShapes() {
        return this.listReversedTripShapes(1.0);
    }

    public ValidationResult listStopsAwayFromShape(Double minDistance) {
        List shapeIds = this.gtfsDao.getAllShapeIds();
        TripPatternCollection tripPatterns = new TripPatternCollection(shapeIds.size() * 2);
        String problemDescription = "Stop is more than " + minDistance + "m from shape";
        ValidationResult result = new ValidationResult();
        for (AgencyAndId shapeId : shapeIds) {
            Geometry shapeLine = GeoUtils.getGeomFromShapePoints(this.gtfsDao.getShapePointsForShapeId(shapeId));
            List tripsForShape = this.gtfsDao.getTripsForShapeId(shapeId);
            for (Trip trip : tripsForShape) {
                List stopTimes;
                Route routeId = trip.getRoute();
                if (tripPatterns.addIfNotPresent(routeId, shapeId, stopTimes = this.gtfsDao.getStopTimesForTrip(trip)).booleanValue()) continue;
                for (StopTime stopTime : stopTimes) {
                    StopLocation stop = stopTime.getStop();
                    try {
                        Geometry stopGeom = GeoUtils.getGeometryFromCoordinate(((Stop)stop).getLat(), ((Stop)stop).getLon());
                        if (!(shapeLine.distance(stopGeom) > minDistance)) continue;
                        String problem = stop.getId().toString() + " on " + shapeId.getId();
                        InvalidValue iv = new InvalidValue("shape", "shape_lat,shape_lon", problem, "StopOffShape", problemDescription, shapeId.getId(), Priority.MEDIUM);
                        result.add(iv);
                    }
                    catch (Exception e) {
                        result.add(new InvalidValue("stop", "shapeId", shapeId.toString(), "Illegal stopCoord for shape", "", null, Priority.MEDIUM));
                    }
                }
            }
        }
        return result;
    }

    public ValidationResult listReversedTripShapes(Double distanceMultiplier) {
        ValidationResult result = new ValidationResult();
        Collection trips = this.gtfsDao.getAllTrips();
        Collection stopTimes = this.gtfsDao.getAllStopTimes();
        int numTrips = this.gtfsDao.getAllTrips().size();
        HashMap<String, StopTime> firstStopMap = new HashMap<String, StopTime>(numTrips * 2);
        HashMap<String, StopTime> lastStopMap = new HashMap<String, StopTime>(numTrips * 2);
        for (StopTime stopTime : stopTimes) {
            String tripId = stopTime.getTrip().getId().toString();
            if (firstStopMap.containsKey(tripId)) {
                if (((StopTime)firstStopMap.get(tripId)).getStopSequence() > stopTime.getStopSequence()) {
                    firstStopMap.put(tripId, stopTime);
                }
            } else {
                firstStopMap.put(tripId, stopTime);
            }
            if (lastStopMap.containsKey(tripId)) {
                if (((StopTime)lastStopMap.get(tripId)).getStopSequence() >= stopTime.getStopSequence()) continue;
                lastStopMap.put(tripId, stopTime);
                continue;
            }
            lastStopMap.put(tripId, stopTime);
        }
        Collection shapePoints = this.gtfsDao.getAllShapePoints();
        HashMap<String, ShapePoint> firstShapePoint = new HashMap<String, ShapePoint>(numTrips * 2);
        HashMap<String, ShapePoint> lastShapePoint = new HashMap<String, ShapePoint>(numTrips * 2);
        for (ShapePoint shapePoint : shapePoints) {
            String shapeId = shapePoint.getShapeId().getId();
            if (firstShapePoint.containsKey(shapeId)) {
                if (((ShapePoint)firstShapePoint.get(shapeId)).getSequence() > shapePoint.getSequence()) {
                    firstShapePoint.put(shapeId, shapePoint);
                }
            } else {
                firstShapePoint.put(shapeId, shapePoint);
            }
            if (lastShapePoint.containsKey(shapeId)) {
                if (((ShapePoint)lastShapePoint.get(shapeId)).getSequence() >= shapePoint.getSequence()) continue;
                lastShapePoint.put(shapeId, shapePoint);
                continue;
            }
            lastShapePoint.put(shapeId, shapePoint);
        }
        for (Trip trip : trips) {
            String tripId = trip.getId().toString();
            if (trip.getShapeId() == null) {
                InvalidValue iv = new InvalidValue("trip", "shape_id", tripId, "MissingShape", "Trip " + tripId + " is missing a shape", null, Priority.MEDIUM);
                iv.route = trip.getRoute();
                result.add(iv);
                continue;
            }
            String shapeId = trip.getShapeId().getId();
            StopTime firstStop = (StopTime)firstStopMap.get(tripId);
            StopTime lastStop = (StopTime)lastStopMap.get(tripId);
            Coordinate firstStopCoord = null;
            Coordinate lastStopCoord = null;
            Point firstShapeGeom = null;
            Point lastShapeGeom = null;
            Point firstStopGeom = null;
            Point lastStopGeom = null;
            Coordinate firstShapeCoord = null;
            Coordinate lastShapeCoord = null;
            try {
                firstStopCoord = new Coordinate(((Stop)firstStop.getStop()).getLat(), ((Stop)firstStop.getStop()).getLon());
                lastStopCoord = new Coordinate(((Stop)lastStop.getStop()).getLat(), ((Stop)lastStop.getStop()).getLon());
                firstStopGeom = geometryFactory.createPoint((Coordinate)GeoUtils.convertLatLonToEuclidean(firstStopCoord));
                lastStopGeom = geometryFactory.createPoint((Coordinate)GeoUtils.convertLatLonToEuclidean(lastStopCoord));
                firstShapeCoord = new Coordinate(((ShapePoint)firstShapePoint.get(shapeId)).getLat(), ((ShapePoint)firstShapePoint.get(shapeId)).getLon());
                lastShapeCoord = new Coordinate(((ShapePoint)lastShapePoint.get(shapeId)).getLat(), ((ShapePoint)firstShapePoint.get(shapeId)).getLon());
                firstShapeGeom = geometryFactory.createPoint((Coordinate)GeoUtils.convertLatLonToEuclidean(firstShapeCoord));
                lastShapeGeom = geometryFactory.createPoint((Coordinate)GeoUtils.convertLatLonToEuclidean(lastShapeCoord));
            }
            catch (Exception any) {
                InvalidValue iv = new InvalidValue("trip", "shape_id", tripId, "MissingCoordinates", "Trip " + tripId + " is missing coordinates", null, Priority.MEDIUM);
                iv.route = trip.getRoute();
                result.add(iv);
                continue;
            }
            firstShapeCoord = new Coordinate(((ShapePoint)firstShapePoint.get(shapeId)).getLat(), ((ShapePoint)firstShapePoint.get(shapeId)).getLon());
            lastShapeCoord = new Coordinate(((ShapePoint)lastShapePoint.get(shapeId)).getLat(), ((ShapePoint)firstShapePoint.get(shapeId)).getLon());
            Double distanceFirstStopToStart = firstStopGeom.distance((Geometry)firstShapeGeom);
            Double distanceFirstStopToEnd = firstStopGeom.distance((Geometry)lastShapeGeom);
            Double distanceLastStopToEnd = lastStopGeom.distance((Geometry)lastShapeGeom);
            Double distanceLastStopToStart = lastStopGeom.distance((Geometry)firstShapeGeom);
            if (!(distanceFirstStopToStart > distanceFirstStopToEnd * distanceMultiplier) || !(distanceLastStopToEnd > distanceLastStopToStart * distanceMultiplier)) continue;
            InvalidValue iv = new InvalidValue("trip", "shape_id", tripId, "ReversedTripShape", "Trip " + tripId + " references reversed shape " + shapeId, null, Priority.MEDIUM);
            iv.route = trip.getRoute();
            result.add(iv);
        }
        return result;
    }
}

