/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.service;

import com.conveyal.gtfs.model.ProjectedCoordinate;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.geotools.geometry.GeometryBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.onebusaway.gtfs.model.ShapePoint;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeoUtils {
    public static double RADIANS = Math.PI * 2;
    public static MathTransform recentMathTransform = null;
    public static GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), 4326);
    public static GeometryFactory projectedGeometryFactory = new GeometryFactory(new PrecisionModel());
    public static GeometryBuilder builder = new GeometryBuilder((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);

    public static ProjectedCoordinate convertLatLonToEuclidean(Coordinate latlon) {
        Coordinate lonlat = new Coordinate(latlon.y, latlon.x);
        return GeoUtils.convertLonLatToEuclidean(lonlat);
    }

    private static ProjectedCoordinate convertLonLatToEuclidean(Coordinate lonlat) {
        MathTransform transform = GeoUtils.getTransform(lonlat);
        Coordinate to = new Coordinate();
        Coordinate latlon = new Coordinate(lonlat.y, lonlat.x);
        try {
            JTS.transform((Coordinate)latlon, (Coordinate)to, (MathTransform)transform);
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        return new ProjectedCoordinate(transform, new Coordinate(to.y, to.x), lonlat);
    }

    public static Coordinate convertToLatLon(MathTransform transform, Coordinate xy) {
        Coordinate lonlat = GeoUtils.convertToLonLat(transform, xy);
        return new Coordinate(lonlat.y, lonlat.x);
    }

    public static Coordinate convertToLonLat(MathTransform transform, Coordinate xy) {
        Coordinate to = new Coordinate();
        Coordinate yx = new Coordinate(xy.y, xy.x);
        try {
            JTS.transform((Coordinate)yx, (Coordinate)to, (MathTransform)transform.inverse());
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        return new Coordinate(to.y, to.x);
    }

    public static Coordinate convertToLatLon(ProjectedCoordinate pc) {
        Coordinate point = new Coordinate(pc.getX(), pc.getY());
        return GeoUtils.convertToLatLon(pc.getTransform(), point);
    }

    public static Coordinate convertToLonLat(ProjectedCoordinate pc) {
        Coordinate point = new Coordinate(pc.getX(), pc.getY());
        return GeoUtils.convertToLonLat(pc.getTransform(), point);
    }

    public static Geometry getGeometryFromCoordinate(double lat, double lon) throws IllegalArgumentException {
        Coordinate stopCoord = new Coordinate(lat, lon);
        ProjectedCoordinate projectedStopCoord = null;
        projectedStopCoord = GeoUtils.convertLatLonToEuclidean(stopCoord);
        return geometryFactory.createPoint((Coordinate)projectedStopCoord);
    }

    public static Geometry getGeomFromShapePoints(List<ShapePoint> shapePoints) throws IllegalArgumentException {
        ArrayList<ProjectedCoordinate> shapeCoords = new ArrayList<ProjectedCoordinate>();
        TreeSet<ShapePoint> linkedShapePoints = new TreeSet<ShapePoint>();
        try {
            linkedShapePoints.addAll(shapePoints);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ShapePoint shapePoint : linkedShapePoints) {
            Coordinate coord = new Coordinate(shapePoint.getLat(), shapePoint.getLon());
            ProjectedCoordinate projectedCoord = GeoUtils.convertLatLonToEuclidean(coord);
            if (projectedCoord.getX() == Double.NaN || projectedCoord.getY() == Double.NaN) {
                throw new IllegalArgumentException("Something is wrong with " + shapePoint.getId() + " on shape " + shapePoint.getShapeId());
            }
            shapeCoords.add(projectedCoord);
        }
        LineString geom = geometryFactory.createLineString(shapeCoords.toArray(new Coordinate[shapePoints.size()]));
        return geom;
    }

    public static int getEPSGCodefromUTS(Coordinate refLonLat) {
        int epsg_code = 32600;
        if (refLonLat.y < 0.0) {
            epsg_code += 100;
        }
        return epsg_code += GeoUtils.getUTMZoneForLongitude(refLonLat.x);
    }

    public static double getMetersInAngleDegrees(double distance) {
        return distance / (Math.PI / 180) / 6378137.0;
    }

    public static MathTransform getTransform(Coordinate refLatLon) {
        try {
            MathTransform transform;
            CRSAuthorityFactory crsAuthorityFactory = CRS.getAuthorityFactory((boolean)false);
            GeographicCRS geoCRS = crsAuthorityFactory.createGeographicCRS("EPSG:4326");
            CoordinateReferenceSystem dataCRS = crsAuthorityFactory.createCoordinateReferenceSystem("EPSG:" + GeoUtils.getEPSGCodefromUTS(refLatLon));
            recentMathTransform = transform = CRS.findMathTransform((CoordinateReferenceSystem)geoCRS, (CoordinateReferenceSystem)dataCRS);
            return transform;
        }
        catch (NoSuchIdentifierException e) {
            e.printStackTrace();
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int getUTMZoneForLongitude(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            throw new IllegalArgumentException("Coordinates not within UTM zone limits");
        }
        int lonZone = (int)((lon + 180.0) / 6.0);
        if (lonZone == 60) {
            --lonZone;
        }
        return lonZone + 1;
    }
}

