/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.StopTime;

public class TripPatternCollection {
    private Set<TripPattern> patterns;

    public TripPatternCollection(int estimatedSize) {
        this.patterns = new LinkedHashSet<TripPattern>(estimatedSize);
    }

    public void add(Route routeId, AgencyAndId shapeId, List<StopTime> stops) {
        TripPattern tp = new TripPattern(routeId, shapeId, stops.size());
        this.patterns.add(tp);
    }

    public Boolean addIfNotPresent(Route routeId, AgencyAndId shapeId, List<StopTime> stops) {
        TripPattern tp = new TripPattern(routeId, shapeId, stops.size());
        Boolean present = this.patterns.contains(tp);
        if (!present.booleanValue()) {
            this.patterns.add(tp);
        }
        return present;
    }

    private class TripPattern {
        private String routeId;
        private String shapeId;
        private int stopHash;

        private TripPattern(Route route, AgencyAndId shape, int stopHash) {
            this.routeId = route.toString();
            this.shapeId = shape.toString();
            this.stopHash = stopHash;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.routeId == null ? 0 : this.routeId.hashCode());
            result = 31 * result + (this.shapeId == null ? 0 : this.shapeId.hashCode());
            result = 31 * result + this.stopHash;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TripPattern other = (TripPattern)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.routeId == null ? other.routeId != null : !this.routeId.equals(other.routeId)) {
                return false;
            }
            if (this.shapeId == null ? other.shapeId != null : !this.shapeId.equals(other.shapeId)) {
                return false;
            }
            return this.stopHash == other.stopHash;
        }

        private TripPatternCollection getOuterType() {
            return TripPatternCollection.this;
        }
    }
}

