/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.service.GeoUtils;
import com.vividsolutions.jts.geom.Coordinate;
import org.opengis.referencing.operation.MathTransform;

public class ProjectedCoordinate
extends Coordinate {
    private static final long serialVersionUID = 2905131060296578237L;
    private final MathTransform transform;
    private final Coordinate refLatLon;

    public ProjectedCoordinate(MathTransform mathTransform, Coordinate to, Coordinate refLatLon) {
        this.transform = mathTransform;
        this.x = to.x;
        this.y = to.y;
        this.refLatLon = refLatLon;
    }

    public String epsgCode() {
        String epsgCode = "EPSG:" + GeoUtils.getEPSGCodefromUTS(this.refLatLon);
        return epsgCode;
    }

    public Coordinate getReferenceLatLon() {
        return this.refLatLon;
    }

    public MathTransform getTransform() {
        return this.transform;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }
}

