/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.util;

import java.util.Calendar;
import java.util.Date;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;

public class CalendarFunctions {
    public boolean isTripActive(GtfsMutableRelationalDao dao, ServiceDate serviceDate, Trip trip, boolean matchDayInCalendar) {
        Date testDate = serviceDate.getAsDate();
        boolean hasCalDateException = false;
        if (!dao.getCalendarDatesForServiceId(trip.getServiceId()).isEmpty()) {
            for (ServiceCalendarDate serviceCalendarDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                Date date = this.constructDate(serviceCalendarDate.getDate());
                if (!date.equals(testDate)) continue;
                hasCalDateException = true;
                if (serviceCalendarDate.getExceptionType() != 1) continue;
                return true;
            }
        }
        if (!hasCalDateException) {
            ServiceCalendar servCal = dao.getCalendarForServiceId(trip.getServiceId());
            if (servCal == null) {
                for (ServiceCalendar calendar : dao.getAllCalendars()) {
                    if (!calendar.getServiceId().getId().equals(trip.getServiceId().getId())) continue;
                    servCal = calendar;
                }
            }
            if (servCal != null) {
                Date date = this.removeTime(servCal.getStartDate().getAsDate());
                Date end = this.removeTime(servCal.getEndDate().getAsDate());
                if (testDate.equals(date) || testDate.equals(end) || testDate.after(date) && testDate.before(end)) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(testDate);
                    if (!matchDayInCalendar) {
                        return true;
                    }
                    switch (cal.get(7)) {
                        case 1: {
                            return servCal.getSunday() == 1;
                        }
                        case 2: {
                            return servCal.getMonday() == 1;
                        }
                        case 3: {
                            return servCal.getTuesday() == 1;
                        }
                        case 4: {
                            return servCal.getWednesday() == 1;
                        }
                        case 5: {
                            return servCal.getThursday() == 1;
                        }
                        case 6: {
                            return servCal.getFriday() == 1;
                        }
                        case 7: {
                            return servCal.getSaturday() == 1;
                        }
                    }
                    throw new IllegalStateException("unexected value " + cal.get(7));
                }
            }
        }
        return false;
    }

    public Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }

    public Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }

    public Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }
}

