/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyBusService
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(VerifyBusService.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        String feed = CloudContextService.getLikelyFeedName(dao);
        CalendarService refCalendarService = CalendarServiceDataFactoryImpl.createService(reference);
        AgencyAndId refAgencyAndId = reference.getAllTrips().iterator().next().getId();
        int curSerRoute = 0;
        int alarmingRoutes = 0;
        Date today = this.removeTime(new Date());
        HashSet<String> ATISrouteIds = new HashSet<String>();
        for (Route route : dao.getAllRoutes()) {
            ATISrouteIds.add(route.getId().getId());
            this._log.info("Adding route: {}", (Object)route.getId().getId());
            curSerRoute = 0;
            block1: for (Trip trip1 : dao.getTripsForRoute(route)) {
                for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(trip1.getServiceId())) {
                    Date date = this.constructDate(calDate.getDate());
                    if (calDate.getExceptionType() != 1 || !date.equals(today)) continue;
                    this._log.info("ATIS has current service for route: {}", (Object)route.getId().getId());
                    ++curSerRoute;
                    break block1;
                }
            }
            if (curSerRoute != 0) continue;
            this._log.error("No current service for {}", (Object)route.getId().getId());
            ServiceDate sToday = this.createServiceDate(today);
            Route refRoute = reference.getRouteForId(new AgencyAndId(refAgencyAndId.getAgencyId(), route.getId().getId()));
            for (Trip refTrip : reference.getTripsForRoute(refRoute)) {
                Set<ServiceDate> activeDates = refCalendarService.getServiceDatesForServiceId(refTrip.getServiceId());
                if (!activeDates.contains(sToday)) continue;
                this._log.info("Reference has service for this bus route today but ATIS does not: {}", (Object)route.getId());
                ++alarmingRoutes;
            }
        }
        es.publishMetric(CloudContextService.getNamespace(), "RoutesMissingTripsFromAtisButInRefToday", "feed", feed, alarmingRoutes);
        es.publishMetric(CloudContextService.getNamespace(), "RoutesContainingTripsToday", "feed", feed, curSerRoute);
    }

    private Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    private ServiceDate createServiceDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new ServiceDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }
}

