/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;

class TripKey {
    private final StopLocation[] _stops;
    private final int[] _arrivalTimes;
    private final int[] _departureTimes;

    public static Map<TripKey, List<Trip>> groupTripsForRouteByKey(GtfsMutableRelationalDao dao, Route route) {
        List<Trip> trips = dao.getTripsForRoute(route);
        FactoryMap<TripKey, List<Trip>> tripsByKey = new FactoryMap<TripKey, List<Trip>>(new ArrayList());
        for (Trip trip : trips) {
            TripKey key = TripKey.getTripKeyForTrip(dao, trip);
            ((List)tripsByKey.get(key)).add(trip);
        }
        return tripsByKey;
    }

    public static TripKey getTripKeyForTrip(GtfsMutableRelationalDao dao, Trip trip) {
        List<StopTime> stopTimes = dao.getStopTimesForTrip(trip);
        StopLocation[] stops = new Stop[stopTimes.size()];
        int[] arrivalTimes = new int[stopTimes.size()];
        int[] departureTimes = new int[stopTimes.size()];
        for (int i = 0; i < stopTimes.size(); ++i) {
            StopTime stopTime = stopTimes.get(i);
            stops[i] = stopTime.getStop();
            arrivalTimes[i] = stopTime.getArrivalTime();
            departureTimes[i] = stopTime.getDepartureTime();
        }
        return new TripKey(stops, arrivalTimes, departureTimes);
    }

    public TripKey(StopLocation[] stops, int[] arrivalTimes, int[] departureTimes) {
        this._stops = stops;
        this._arrivalTimes = arrivalTimes;
        this._departureTimes = departureTimes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._arrivalTimes);
        result = 31 * result + Arrays.hashCode(this._departureTimes);
        result = 31 * result + Arrays.hashCode(this._stops);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TripKey other = (TripKey)obj;
        if (!Arrays.equals(this._arrivalTimes, other._arrivalTimes)) {
            return false;
        }
        if (!Arrays.equals(this._departureTimes, other._departureTimes)) {
            return false;
        }
        return Arrays.equals(this._stops, other._stops);
    }
}

