/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.match.TypedEntityMatch;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;

public class TrimTripTransformStrategy
implements GtfsTransformStrategy {
    private List<TrimOperation> _operations = new ArrayList<TrimOperation>();

    public void addOperation(TrimOperation operation) {
        this._operations.add(operation);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        ArrayList<Trip> tripsToAdd = new ArrayList<Trip>();
        ArrayList<StopTime> stopTimesToAdd = new ArrayList<StopTime>();
        ArrayList<Trip> tripsToRemove = new ArrayList<Trip>();
        ArrayList<StopTime> stopTimesToRemove = new ArrayList<StopTime>();
        HashSet<AgencyAndId> newShapeIds = new HashSet<AgencyAndId>();
        for (Trip trip : dao.getAllTrips()) {
            List<TrimOperation> operations = this.getMatchingOperations(trip);
            if (operations.isEmpty()) continue;
            List<StopTime> stopTimes = dao.getStopTimesForTrip(trip);
            Map<String, Integer> stopToIndex = this.getStopIndices(stopTimes);
            boolean removeOriginalTrip = false;
            for (TrimOperation operation : operations) {
                Integer n;
                Integer n2;
                Integer preIndex = stopToIndex.get(operation.getToStopId());
                Integer postIndex = stopToIndex.get(operation.getFromStopId());
                if (postIndex == null && preIndex == null) continue;
                removeOriginalTrip = true;
                Trip newTrip = new Trip(trip);
                Object id = newTrip.getId().getId();
                if (preIndex != null) {
                    id = (String)id + "-" + operation.getToStopId();
                }
                if (postIndex != null) {
                    id = (String)id + "-" + operation.getFromStopId();
                }
                if (preIndex == null) {
                    preIndex = 0;
                } else {
                    n2 = preIndex;
                    n = preIndex = Integer.valueOf(preIndex + 1);
                }
                if (postIndex == null) {
                    postIndex = stopTimes.size() - 1;
                } else {
                    n2 = postIndex;
                    n = postIndex = Integer.valueOf(postIndex - 1);
                }
                newTrip.setId(new AgencyAndId(trip.getId().getAgencyId(), (String)id));
                ArrayList<StopTime> newStopTimes = new ArrayList<StopTime>();
                for (int i = preIndex.intValue(); i <= postIndex; ++i) {
                    StopTime stopTime = new StopTime(stopTimes.get(i));
                    stopTime.setId(0);
                    stopTime.setTrip(newTrip);
                    newStopTimes.add(stopTime);
                }
                if (newStopTimes.isEmpty()) continue;
                this.updateShape(dao, newTrip, newStopTimes, newShapeIds);
                tripsToAdd.add(newTrip);
                stopTimesToAdd.addAll(newStopTimes);
            }
            if (!removeOriginalTrip) continue;
            tripsToRemove.add(trip);
            stopTimesToRemove.addAll(stopTimes);
        }
        for (StopTime stopTime : stopTimesToRemove) {
            dao.removeEntity(stopTime);
        }
        for (Trip trip : tripsToRemove) {
            dao.removeEntity(trip);
        }
        for (Trip trip : tripsToAdd) {
            dao.saveEntity(trip);
        }
        for (StopTime stopTime : stopTimesToAdd) {
            dao.saveEntity(stopTime);
        }
        UpdateLibrary.clearDaoCache(dao);
        HashSet<AgencyAndId> shapeIds = new HashSet<AgencyAndId>(dao.getAllShapeIds());
        for (Trip trip : dao.getAllTrips()) {
            shapeIds.remove(trip.getShapeId());
        }
        for (AgencyAndId shapeId : shapeIds) {
            for (ShapePoint point : dao.getShapePointsForShapeId(shapeId)) {
                dao.removeEntity(point);
            }
        }
    }

    private List<TrimOperation> getMatchingOperations(Trip trip) {
        ArrayList<TrimOperation> matching = new ArrayList<TrimOperation>();
        for (TrimOperation operation : this._operations) {
            if (!operation.getMatch().isApplicableToObject(trip)) continue;
            matching.add(operation);
        }
        return matching;
    }

    private void updateShape(GtfsMutableRelationalDao dao, Trip trip, List<StopTime> stopTimes, Set<AgencyAndId> newShapeIds) {
        if (stopTimes.size() < 2) {
            trip.setShapeId(null);
            return;
        }
        AgencyAndId shapeId = trip.getShapeId();
        if (shapeId == null || !shapeId.hasValues()) {
            return;
        }
        List<ShapePoint> points = dao.getShapePointsForShapeId(shapeId);
        if (points.isEmpty()) {
            return;
        }
        StopLocation firstStop = stopTimes.get(0).getStop();
        StopLocation lastStop = stopTimes.get(stopTimes.size() - 1).getStop();
        String id = shapeId.getId() + "-" + firstStop.getId().getId() + "-" + lastStop.getId().getId();
        AgencyAndId newShapeId = new AgencyAndId(shapeId.getAgencyId(), id);
        trip.setShapeId(newShapeId);
        if (!(firstStop instanceof Stop)) {
            throw new Error(firstStop + " must be stop");
        }
        if (!(lastStop instanceof Stop)) {
            throw new Error(firstStop + " must be stop");
        }
        if (!newShapeIds.add(newShapeId)) {
            return;
        }
        int shapePointFrom = this.getClosestShapePointToStop(points, (Stop)firstStop);
        int shapePointTo = this.getClosestShapePointToStop(points, (Stop)lastStop);
        for (int index = shapePointFrom; index <= shapePointTo; ++index) {
            ShapePoint point = new ShapePoint(points.get(index));
            point.setId(0);
            point.setShapeId(newShapeId);
            dao.saveEntity(point);
        }
    }

    private int getClosestShapePointToStop(List<ShapePoint> points, Stop stop) {
        int minIndex = -1;
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < points.size(); ++i) {
            double dy;
            ShapePoint point = points.get(i);
            double dx = point.getLon() - stop.getLon();
            double d = Math.sqrt(dx * dx + (dy = point.getLat() - stop.getLat()) * dy);
            if (!(d < minDistance)) continue;
            minIndex = i;
            minDistance = d;
        }
        return minIndex;
    }

    private Map<String, Integer> getStopIndices(List<StopTime> stopTimes) {
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        int index = 0;
        for (StopTime stopTime : stopTimes) {
            String id = stopTime.getStop().getId().getId();
            if (!indices.containsKey(id)) {
                indices.put(id, index);
            }
            ++index;
        }
        return indices;
    }

    public static class TrimOperation {
        private TypedEntityMatch match;
        private String fromStopId;
        private String toStopId;

        public TypedEntityMatch getMatch() {
            return this.match;
        }

        public void setMatch(TypedEntityMatch match) {
            this.match = match;
        }

        public String getFromStopId() {
            return this.fromStopId;
        }

        public void setFromStopId(String fromStopId) {
            this.fromStopId = fromStopId;
        }

        public String getToStopId() {
            return this.toStopId;
        }

        public void setToStopId(String toStopId) {
            this.toStopId = toStopId;
        }
    }
}

