/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirtyDayCalendarExtensionStrategy
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(ThirtyDayCalendarExtensionStrategy.class);
    private final long milisPerDay = 86400000L;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        Map<Date, List<ServiceCalendar>> serviceIdsByDate = this.getServiceIdsByDate(dao, this.removeTime(new Date(System.currentTimeMillis() - 604800000L)), this.removeTime(new Date(System.currentTimeMillis() + 2678400000L)));
        for (int i = 31; i > 24; --i) {
            this.ensureActiveCalendar(i, serviceIdsByDate, dao);
        }
    }

    private void ensureActiveCalendar(int daysFromNow, Map<Date, List<ServiceCalendar>> serviceIdsByDate, GtfsMutableRelationalDao dao) {
        Date date = this.removeTime(new Date(System.currentTimeMillis() + (long)daysFromNow * 86400000L));
        List<ServiceCalendar> activeServiceIds = this.getLastActiveCalendar(daysFromNow, serviceIdsByDate);
        Iterator<ServiceCalendar> iterator = activeServiceIds.iterator();
        while (iterator.hasNext()) {
            ServiceCalendar serviceId;
            ServiceCalendar serviceCalendar = serviceId = iterator.next();
            serviceCalendar.setEndDate(new ServiceDate(date));
            dao.saveOrUpdateEntity(serviceCalendar);
            dao.flush();
        }
    }

    private List<ServiceCalendar> getLastActiveCalendar(int daysFromNow, Map<Date, List<ServiceCalendar>> serviceIdsByDate) {
        if (daysFromNow < -7) {
            return null;
        }
        Date date = this.removeTime(new Date(System.currentTimeMillis() + (long)daysFromNow * 86400000L));
        List<ServiceCalendar> activeServiceIds = serviceIdsByDate.get(date);
        if (activeServiceIds == null) {
            activeServiceIds = this.getLastActiveCalendar(daysFromNow - 7, serviceIdsByDate);
        }
        if (activeServiceIds != null) {
            return activeServiceIds;
        }
        return activeServiceIds;
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    private Map<Date, List<ServiceCalendar>> getServiceIdsByDate(GtfsMutableRelationalDao dao, Date minDate, Date maxDate) {
        HashMap<Date, List<ServiceCalendar>> serviceIdsByDate = new HashMap<Date, List<ServiceCalendar>>();
        for (AgencyAndId serviceId : dao.getAllServiceIds()) {
            Date end;
            ServiceCalendar servCal = dao.getCalendarForServiceId(serviceId);
            if (servCal == null) continue;
            Date start = this.removeTime(servCal.getStartDate().getAsDate());
            if (minDate.after(start)) {
                start = minDate;
            }
            if ((end = this.removeTime(this.addDays(servCal.getEndDate().getAsDate(), 1))).after(maxDate)) {
                end = maxDate;
            }
            int dayIndexCounter = 0;
            Date index = this.removeTime(this.addDays(start, dayIndexCounter));
            int[] activeDays = new int[]{0, servCal.getSunday(), servCal.getMonday(), servCal.getTuesday(), servCal.getWednesday(), servCal.getThursday(), servCal.getFriday(), servCal.getSaturday()};
            while (index.before(end)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(index);
                int day = calendar.get(7);
                if (activeDays[day] == 1) {
                    if (serviceIdsByDate.get(index) == null) {
                        serviceIdsByDate.put(index, new ArrayList());
                    }
                    ((List)serviceIdsByDate.get(index)).add(servCal);
                }
                index = this.removeTime(this.addDays(start, ++dayIndexCounter));
            }
        }
        return serviceIdsByDate;
    }

    private Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }
}

