/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;

public class ShapeTransformStrategy
implements GtfsTransformStrategy {
    private String shapeId;
    private String shape;
    private boolean matchStart = true;
    private boolean matchEnd = true;

    public void setShapeId(String ashapeId) {
        this.shapeId = ashapeId;
    }

    public void setShape(String ashape) {
        this.shape = ashape;
    }

    public void setMatchStart(boolean amatchStart) {
        this.matchStart = amatchStart;
    }

    public void setMatchEnd(boolean amatchEnd) {
        this.matchEnd = amatchEnd;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        String agencyId = context.getDefaultAgencyId();
        AgencyAndId ashapeId = new AgencyAndId(agencyId, this.shapeId);
        List<ShapePoint> shapePoints = dao.getShapePointsForShapeId(ashapeId);
        if (shapePoints.isEmpty()) {
            System.err.println("no points found for shape: " + ashapeId);
            return;
        }
        shapePoints = new ArrayList<ShapePoint>(shapePoints);
        List<ShapePoint> segment = this.decode(this.shape);
        ShapePoint from = segment.get(0);
        ShapePoint to = segment.get(segment.size() - 1);
        int fromIndex = 0;
        int toIndex = shapePoints.size() - 1;
        if (this.matchStart) {
            fromIndex = this.closest(shapePoints, from, 0);
        }
        if (this.matchEnd) {
            toIndex = this.closest(shapePoints, to, fromIndex);
        }
        if (toIndex < fromIndex) {
            System.err.println("segment match is out of order: fromIndex=" + fromIndex + " toIndex=" + toIndex);
            return;
        }
        List<ShapePoint> subList = shapePoints.subList(fromIndex, toIndex + 1);
        for (ShapePoint point : subList) {
            dao.removeEntity(point);
        }
        subList.clear();
        subList.addAll(segment);
        int index = 0;
        for (ShapePoint point : shapePoints) {
            point.setDistTraveled(-999.0);
            point.setSequence(index++);
            point.setShapeId(ashapeId);
        }
        for (ShapePoint point : segment) {
            dao.saveEntity(point);
        }
        UpdateLibrary.clearDaoCache(dao);
    }

    private int closest(List<ShapePoint> shapePoints, ShapePoint point, int index) {
        int minIndex = -1;
        double minValue = Double.POSITIVE_INFINITY;
        for (int i = index; i < shapePoints.size(); ++i) {
            double dx;
            ShapePoint p = shapePoints.get(i);
            double dy = p.getLat() - point.getLat();
            double d = Math.sqrt(dy * dy + (dx = p.getLon() - point.getLon()) * dx);
            if (!(d < minValue)) continue;
            minIndex = i;
            minValue = d;
        }
        return minIndex;
    }

    private List<ShapePoint> decode(String pointString) {
        double lat = 0.0;
        double lon = 0.0;
        int strIndex = 0;
        ArrayList<ShapePoint> points = new ArrayList<ShapePoint>();
        while (strIndex < pointString.length()) {
            int[] rLat = this.decodeSignedNumberWithIndex(pointString, strIndex);
            strIndex = rLat[1];
            int[] rLon = this.decodeSignedNumberWithIndex(pointString, strIndex);
            strIndex = rLon[1];
            ShapePoint point = new ShapePoint();
            point.setLat(lat += (double)rLat[0] * 1.0E-5);
            point.setLon(lon += (double)rLon[0] * 1.0E-5);
            points.add(point);
        }
        return points;
    }

    private int[] decodeSignedNumberWithIndex(String value, int index) {
        int[] r = this.decodeNumberWithIndex(value, index);
        int sgn_num = r[0];
        if ((sgn_num & 1) > 0) {
            sgn_num ^= 0xFFFFFFFF;
        }
        r[0] = sgn_num >> 1;
        return r;
    }

    private int[] decodeNumberWithIndex(String value, int index) {
        if (value.length() == 0) {
            throw new IllegalArgumentException("string is empty");
        }
        int num = 0;
        int v = 0;
        int shift = 0;
        do {
            v = value.charAt(index++) - 63;
            num |= (v & 0x1F) << shift;
            shift += 5;
        } while (v >= 32);
        return new int[]{num, index};
    }
}

