/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;

public class RemoveStopsFromShapesStrategy
implements GtfsTransformStrategy {
    @Override
    public String getName() {
        return "RemoveStopsFromShapesStrategy";
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        List<AgencyAndId> allShapeIds = dao.getAllShapeIds();
        List<Coord> allStopPoints = this.loadAllStopPoints(dao);
        for (AgencyAndId aid : allShapeIds) {
            this.fixShape(dao, allStopPoints, aid);
        }
        UpdateLibrary.clearDaoCache(dao);
    }

    private List<Coord> loadAllStopPoints(GtfsMutableRelationalDao dao) {
        ArrayList<Coord> allStopPoints = new ArrayList<Coord>();
        Collection<Stop> allStops = dao.getAllStops();
        for (Stop stop : allStops) {
            allStopPoints.add(new Coord(stop.getLat(), stop.getLon()));
        }
        return allStopPoints;
    }

    private void fixShape(GtfsMutableRelationalDao dao, List<Coord> allStopPoints, AgencyAndId aid) {
        List<ShapePoint> shapePointsForShapeId = dao.getShapePointsForShapeId(aid);
        for (ShapePoint shapePoint : shapePointsForShapeId) {
            Coord shapeCoord = new Coord(shapePoint.getLat(), shapePoint.getLon());
            if (!allStopPoints.contains(shapeCoord)) continue;
            dao.removeEntity(shapePoint);
        }
    }

    public static class Coord {
        private double lat;
        private double lon;

        public Coord(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        public boolean equals(Object o) {
            Coord c = (Coord)o;
            return c.lat == this.lat && c.lon == this.lon;
        }
    }
}

