/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.List;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveRepeatedStopTimesInSameTripStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(RemoveRepeatedStopTimesInSameTripStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        int removed = 0;
        int total = 0;
        for (Trip trip : dao.getAllTrips()) {
            StopTime prev = null;
            List<StopTime> stopTimes = dao.getStopTimesForTrip(trip);
            for (StopTime stopTime : stopTimes) {
                ++total;
                if (prev != null && prev.getStop().getId().equals(stopTime.getStop().getId())) {
                    stopTime.setArrivalTime(Math.min(prev.getArrivalTime(), stopTime.getArrivalTime()));
                    stopTime.setDepartureTime(Math.max(prev.getDepartureTime(), stopTime.getDepartureTime()));
                    dao.removeEntity(prev);
                    ++removed;
                }
                prev = stopTime;
            }
        }
        _log.info("removed=" + removed + " total=" + total);
        UpdateLibrary.clearDaoCache(dao);
    }
}

