/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.List;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveNonRevenueStopsExcludingTerminalsStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(RemoveNonRevenueStopsExcludingTerminalsStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        int removedStopTimeCount = 0;
        int totalStopTimeCount = 0;
        for (Trip trip : dao.getAllTrips()) {
            List<StopTime> stopTimes = dao.getStopTimesForTrip(trip);
            int tripLength = stopTimes.size();
            for (int i = 0; i < tripLength; ++i) {
                ++totalStopTimeCount;
                StopTime stopTime = stopTimes.get(i);
                if (!this.isNonRevenue(stopTime) || this.isFirstOrLast(i, tripLength)) continue;
                dao.removeEntity(stopTime);
                ++removedStopTimeCount;
            }
        }
        _log.info("removed=" + removedStopTimeCount + " total=" + totalStopTimeCount);
        UpdateLibrary.clearDaoCache(dao);
    }

    private boolean isNonRevenue(StopTime s) {
        return s.getDropOffType() == 1 && s.getPickupType() == 1;
    }

    private boolean isFirstOrLast(int i, int size) {
        return i == 0 || i == size - 1;
    }
}

