/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveMergedTripsStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(RemoveMergedTripsStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        String key;
        String blockId;
        FactoryMap tripsByCommonId = new FactoryMap(new ArrayList());
        for (Trip trip : dao.getAllTrips()) {
            Object id = trip.getId().getId();
            int n = ((String)id).indexOf(95);
            if (n != -1) {
                id = ((String)id).substring(0, n);
            }
            ((List)tripsByCommonId.get(id)).add(trip);
        }
        int removed = 0;
        int total = 0;
        for (Map.Entry entry : tripsByCommonId.entrySet()) {
            String tripId = (String)entry.getKey();
            List trips = (List)entry.getValue();
            if (trips.size() > 2) {
                throw new IllegalStateException();
            }
            if (trips.size() == 2) {
                Collections.sort(trips, new TripComparator());
                Trip a = (Trip)trips.get(0);
                Trip b = (Trip)trips.get(1);
                List<StopTime> sta = dao.getStopTimesForTrip(a);
                List<Frequency> frequenciesForA = dao.getFrequenciesForTrip(a);
                dao.removeEntity(a);
                dao.removeEntity(b);
                for (StopTime st : sta) {
                    dao.removeEntity(st);
                }
                for (Frequency frequency : frequenciesForA) {
                    dao.removeEntity(frequency);
                }
                AgencyAndId id = b.getId();
                id = new AgencyAndId(id.getAgencyId(), tripId);
                b.setId(id);
                dao.saveEntity(b);
                ++removed;
            }
            total += trips.size();
        }
        _log.info("removed: " + removed + "/" + total);
        UpdateLibrary.clearDaoCache(dao);
        FactoryMap m = new FactoryMap(new HashSet());
        for (Trip trip : dao.getAllTrips()) {
            blockId = trip.getBlockId();
            int index = blockId.indexOf(95);
            if (index == -1) continue;
            key = blockId.substring(index + 1);
            ((Set)m.get(key)).add(blockId);
        }
        for (Set v : m.values()) {
            if (v.size() <= 1) continue;
            throw new IllegalStateException(v.toString());
        }
        for (Trip trip : dao.getAllTrips()) {
            blockId = trip.getBlockId();
            int index = blockId.indexOf(95);
            if (index == -1) continue;
            key = blockId.substring(index + 1);
            trip.setBlockId(key);
        }
        UpdateLibrary.clearDaoCache(dao);
    }

    private static class TripComparator
    implements Comparator<Trip> {
        private TripComparator() {
        }

        @Override
        public int compare(Trip o1, Trip o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

