/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.List;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.EntityTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;

public class NoTripsWithBlockIdAndFrequenciesStrategy
implements EntityTransformStrategy {
    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao, Object entity) {
        for (Trip trip : dao.getAllTrips()) {
            List<Frequency> frequencies = dao.getFrequenciesForTrip(trip);
            if (frequencies.isEmpty() || this.isLabelOnly(frequencies) || trip.getBlockId() == null) continue;
            trip.setBlockId(null);
        }
        UpdateLibrary.clearDaoCache(dao);
    }

    private boolean isLabelOnly(List<Frequency> frequencies) {
        for (Frequency frequency : frequencies) {
            if (frequency.getLabelOnly() != 0) continue;
            return false;
        }
        return true;
    }
}

