/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeduplicateServiceIdsStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(DeduplicateServiceIdsStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        CalendarService service = CalendarServiceDataFactoryImpl.createService(dao);
        FactoryMap serviceIdsByServiceDates = new FactoryMap(new ArrayList());
        for (AgencyAndId serviceId : dao.getAllServiceIds()) {
            Set<ServiceDate> serviceDates = service.getServiceDatesForServiceId(serviceId);
            ((List)serviceIdsByServiceDates.get(serviceDates)).add(serviceId);
        }
        HashMap<AgencyAndId, AgencyAndId> serviceIdMapping = new HashMap<AgencyAndId, AgencyAndId>();
        for (List serviceIds : serviceIdsByServiceDates.values()) {
            Collections.sort(serviceIds);
            if (serviceIds.size() == 1) continue;
            AgencyAndId target = (AgencyAndId)serviceIds.get(0);
            for (int i = 1; i < serviceIds.size(); ++i) {
                AgencyAndId source = (AgencyAndId)serviceIds.get(i);
                serviceIdMapping.put(source, target);
            }
        }
        for (Trip trip : dao.getAllTrips()) {
            AgencyAndId mappedServiceId = (AgencyAndId)serviceIdMapping.get(trip.getServiceId());
            if (mappedServiceId == null) continue;
            trip.setServiceId(mappedServiceId);
        }
        for (AgencyAndId serviceId : serviceIdMapping.keySet()) {
            ServiceCalendar serviceCalendar = dao.getCalendarForServiceId(serviceId);
            if (serviceCalendar != null) {
                dao.removeEntity(serviceCalendar);
            }
            for (ServiceCalendarDate date : dao.getCalendarDatesForServiceId(serviceId)) {
                dao.removeEntity(date);
            }
        }
        _log.info("removed {} duplicate service ids", (Object)serviceIdMapping.size());
        UpdateLibrary.clearDaoCache(dao);
    }
}

