/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.CalendarServiceData;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WSFTripResolutionService {
    private static final Logger _log = LoggerFactory.getLogger(WSFTripResolutionService.class);
    GtfsRelationalDao _dao;
    String _agencyId;
    CalendarServiceData _csd;
    TimeZone _agencyTimeZone;
    int _maxStopTime;

    public WSFTripResolutionService(GtfsRelationalDao dao, String agencyId, TimeZone agencyTimeZone) {
        this._dao = dao;
        this._agencyId = agencyId;
        this._agencyTimeZone = agencyTimeZone;
        CalendarServiceDataFactoryImpl factory = new CalendarServiceDataFactoryImpl(this._dao);
        this._csd = factory.createData();
        this._maxStopTime = this.calculateMaxStopTime();
    }

    public Trip resolve(String departingTerminalId, long departureTime, String arrivingTerminalId) {
        ServiceDate initialServiceDate = new ServiceDate(new Date(departureTime * 1000L));
        int lookBackDays = this._maxStopTime / 86400 + 1;
        AgencyAndId stopId = new AgencyAndId(this._agencyId, departingTerminalId);
        AgencyAndId routeId = new AgencyAndId(this._agencyId, departingTerminalId + arrivingTerminalId);
        for (StopTime st : this._dao.getAllStopTimes()) {
            if (!st.getStop().getId().equals(stopId) || !st.getTrip().getRoute().getId().equals(routeId)) continue;
            ServiceDate sd = initialServiceDate;
            for (int i = 0; i < lookBackDays; ++i) {
                if (this._csd.getServiceIdsForDate(sd).contains(st.getTrip().getServiceId()) && (long)st.getDepartureTime() == departureTime - sd.getAsCalendar(this._agencyTimeZone).getTimeInMillis() / 1000L) {
                    return st.getTrip();
                }
                sd = sd.previous();
            }
        }
        _log.warn("no trip found for resolve(departId=" + departingTerminalId + ", departureTime=" + departureTime + ", arrivalId=" + arrivingTerminalId + ")");
        return null;
    }

    private int calculateMaxStopTime() {
        HashSet<Integer> times = new HashSet<Integer>();
        for (StopTime st : this._dao.getAllStopTimes()) {
            if (st.isArrivalTimeSet()) {
                times.add(st.getArrivalTime());
            }
            if (!st.isDepartureTimeSet()) continue;
            times.add(st.getDepartureTime());
        }
        return (Integer)Collections.max(times);
    }
}

