/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.List;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTripHeadsignIfNull
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateTripHeadsignIfNull.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (Trip trip : dao.getAllTrips()) {
            if (trip.getTripHeadsign() != null) continue;
            List<StopTime> stopTimes = dao.getStopTimesForTrip(trip);
            if (stopTimes != null && stopTimes.size() > 0) {
                String tripHeadSign = stopTimes.get(stopTimes.size() - 1).getStop().getName();
                if (tripHeadSign != null) {
                    trip.setTripHeadsign(tripHeadSign);
                    continue;
                }
                this.fallbackSetHeadsign(trip);
                continue;
            }
            this.fallbackSetHeadsign(trip);
        }
    }

    private void fallbackSetHeadsign(Trip trip) {
        if (trip.getTripHeadsign() == null) {
            trip.setTripHeadsign(trip.getRouteShortName());
            this._log.info("Setting headsign to route short name: ", (Object)trip.getRouteShortName());
        }
    }
}

