/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.List;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTripHeadsignExcludeNonreference
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateTripHeadsignExcludeNonreference.class);
    @CsvField(ignore=true)
    private String _referenceAgencyId = null;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        int update = 0;
        int fallback = 0;
        int noChange = 0;
        int shuttle = 0;
        for (Trip trip : dao.getAllTrips()) {
            List<StopTime> stopTimes = dao.getStopTimesForTrip(trip);
            if (stopTimes != null && stopTimes.size() > 0) {
                StopLocation lastStop = stopTimes.get(stopTimes.size() - 1).getStop();
                Stop referenceStop = reference.getStopForId(lastStop.getId());
                if (trip.getTripHeadsign() == null || referenceStop != null) {
                    String tripHeadSign = stopTimes.get(stopTimes.size() - 1).getStop().getName();
                    if (tripHeadSign != null) {
                        trip.setTripHeadsign(tripHeadSign);
                        ++update;
                        continue;
                    }
                    this.fallbackSetHeadsign(trip);
                    ++fallback;
                    continue;
                }
                ++noChange;
                if (!trip.getTripHeadsign().contains("SHUTTLE")) continue;
                ++shuttle;
                continue;
            }
            this.fallbackSetHeadsign(trip);
            ++fallback;
        }
        this._log.info("trip headsign update:{} fallback: {} no change: {} shuttle: {}", update, fallback, noChange, shuttle);
    }

    private void fallbackSetHeadsign(Trip trip) {
        if (trip.getTripHeadsign() == null) {
            trip.setTripHeadsign(trip.getRouteShortName());
        }
    }

    private String getReferenceAgencyId(GtfsMutableRelationalDao dao) {
        if (this._referenceAgencyId == null) {
            this._referenceAgencyId = dao.getAllAgencies().iterator().next().getId();
        }
        return this._referenceAgencyId;
    }
}

