/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStopTimesForTime
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateStopTimesForTime.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        StopTime currentStop = new StopTime();
        int negativeTimes = 0;
        ArrayList<Trip> tripsToRemove = new ArrayList<Trip>();
        block0: for (Trip trip : dao.getAllTrips()) {
            StopTime previousStop = new StopTime();
            previousStop.setArrivalTime(0);
            for (StopTime stopTime : dao.getStopTimesForTrip(trip)) {
                currentStop = stopTime;
                if (currentStop.getArrivalTime() < 0) {
                    this._log.error("Ignoring negative stop time for {}", (Object)currentStop.toString());
                    continue;
                }
                if (previousStop.getArrivalTime() > currentStop.getArrivalTime()) {
                    this._log.info("Time travel! previous arrival time {} this stop {}", (Object)previousStop.displayArrival(), (Object)currentStop.toString());
                    tripsToRemove.add(trip);
                    ++negativeTimes;
                    continue block0;
                }
                previousStop = currentStop;
            }
        }
        this._log.info("Decreasing times: {}, TripsToRemove: {}", (Object)negativeTimes, (Object)tripsToRemove.size());
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        String feed = CloudContextService.getLikelyFeedName(dao);
        es.publishMetric(CloudContextService.getNamespace(), "TripsWithDecreasingStopTimes", "feed", feed, tripsToRemove.size());
        StringBuffer illegalTripList = new StringBuffer();
        for (Trip trip : tripsToRemove) {
            illegalTripList.append(trip.getId().toString()).append(" ");
            removeEntityLibrary.removeTrip(dao, trip);
        }
    }
}

